/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol.internal;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.io.IOException;
import org.openyolo.protocol.MalformedDataException;

public final class IntentProtocolBufferExtractor {
    @NonNull
    public static <T extends MessageLite> T extract(@NonNull String extraName, @NonNull Parser<T> protoParser, @NonNull String failureDescription, @Nullable Intent intent) throws MalformedDataException {
        if (intent == null) {
            throw new MalformedDataException(failureDescription);
        }
        byte[] protoBytes = intent.getByteArrayExtra(extraName);
        if (protoBytes == null) {
            throw new MalformedDataException(failureDescription);
        }
        try {
            return (T)((MessageLite)protoParser.parseFrom(protoBytes));
        }
        catch (IOException ex) {
            throw new MalformedDataException(failureDescription, ex);
        }
    }
}

