/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openyolo.protocol.AdditionalPropertiesHelper;
import org.openyolo.protocol.internal.ByteStringConverters;
import org.openyolo.protocol.internal.CollectionConverter;
import org.openyolo.protocol.internal.CustomMatchers;
import org.valid4j.Validation;

public final class AdditionalPropertiesUtil {
    public static Map<String, ByteString> validateAdditionalProperties(@Nullable Map<String, byte[]> additionalProps) {
        if (additionalProps == null) {
            return new HashMap<String, ByteString>();
        }
        Validation.validate(additionalProps.keySet(), (Matcher)CoreMatchers.everyItem(CustomMatchers.notNullOrEmptyString()), IllegalArgumentException.class);
        Validation.validate(additionalProps.values(), (Matcher)CoreMatchers.everyItem((Matcher)CoreMatchers.notNullValue()), IllegalArgumentException.class);
        return CollectionConverter.convertMapValues(additionalProps, ByteStringConverters.BYTE_ARRAY_TO_BYTE_STRING);
    }

    public static Map<String, ByteString> validateAdditionalPropertiesFromProto(@Nullable Map<String, ByteString> additionalProps) {
        if (additionalProps == null) {
            return new HashMap<String, ByteString>();
        }
        Validation.validate(additionalProps.keySet(), (Matcher)CoreMatchers.everyItem(CustomMatchers.notNullOrEmptyString()), IllegalArgumentException.class);
        Validation.validate(additionalProps.values(), (Matcher)CoreMatchers.everyItem((Matcher)CoreMatchers.notNullValue()), IllegalArgumentException.class);
        return additionalProps;
    }

    @Nullable
    public static byte[] getPropertyValue(Map<String, ByteString> additionalProperties, String key) {
        ByteString value = additionalProperties.get(key);
        if (value == null) {
            return null;
        }
        return value.toByteArray();
    }

    @Nullable
    public static String getPropertyValueAsString(Map<String, ByteString> additionalProperties, String key) {
        return AdditionalPropertiesHelper.decodeStringValue(AdditionalPropertiesUtil.getPropertyValue(additionalProperties, key));
    }

    public static void setPropertyValue(@NonNull Map<String, ByteString> additionalProperties, @NonNull String key, @Nullable byte[] value) {
        ByteString immutableValue = value == null ? null : ByteString.copyFrom((byte[])value);
        additionalProperties.put(key, immutableValue);
    }

    public static void setPropertyValueAsString(@NonNull Map<String, ByteString> additionalProperties, @NonNull String key, @Nullable String value) {
        AdditionalPropertiesUtil.setPropertyValue(additionalProperties, key, AdditionalPropertiesHelper.encodeStringValue(value));
    }

    public static Map<String, byte[]> convertValuesToByteArrays(Map<String, ByteString> additionalProperties) {
        return CollectionConverter.convertMapValues(additionalProperties, ByteStringConverters.BYTE_STRING_TO_BYTE_ARRAY);
    }

    private AdditionalPropertiesUtil() {
        throw new IllegalStateException("not intended to be constructed");
    }
}

