/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.openyolo.protocol.AdditionalPropertiesBuilder;
import org.openyolo.protocol.AdditionalPropertiesContainer;
import org.openyolo.protocol.Credential;
import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.internal.AdditionalPropertiesUtil;
import org.valid4j.Validation;

public final class CredentialRetrieveResult
implements AdditionalPropertiesContainer {
    public static final int CODE_UNKNOWN = 0;
    public static final int CODE_NO_PROVIDER_AVAILABLE = 6;
    public static final int CODE_BAD_REQUEST = 1;
    public static final int CODE_CREDENTIAL_SELECTED = 2;
    public static final int CODE_NO_CREDENTIALS_AVAILABLE = 3;
    public static final int CODE_USER_REQUESTS_MANUAL_AUTH = 4;
    public static final int CODE_USER_CANCELED = 5;
    public static final int CODE_PROVIDER_TIMEOUT = 7;
    public static final CredentialRetrieveResult UNKNOWN = new Builder(0).build();
    public static final CredentialRetrieveResult NO_PROVIDER_AVAILABLE = new Builder(6).build();
    public static final CredentialRetrieveResult BAD_REQUEST = new Builder(1).build();
    public static final CredentialRetrieveResult NO_CREDENTIALS_AVAILABLE = new Builder(3).build();
    public static final CredentialRetrieveResult USER_REQUESTS_MANUAL_AUTH = new Builder(4).build();
    public static final CredentialRetrieveResult USER_CANCELED = new Builder(5).build();
    public static final CredentialRetrieveResult PROVIDER_TIMEOUT = new Builder(7).build();
    private final int mResultCode;
    @Nullable
    private final Credential mCredential;
    @NonNull
    private Map<String, ByteString> mAdditionalProps;

    public static CredentialRetrieveResult fromProtobufBytes(byte[] protobufBytes) throws MalformedDataException {
        Validation.validate((Object)protobufBytes, (Matcher)IsNull.notNullValue(), MalformedDataException.class);
        try {
            return CredentialRetrieveResult.fromProtobuf(Protobufs.CredentialRetrieveResult.parseFrom(protobufBytes));
        }
        catch (InvalidProtocolBufferException ex) {
            throw new MalformedDataException(ex);
        }
    }

    public static CredentialRetrieveResult fromProtobuf(Protobufs.CredentialRetrieveResult proto) throws MalformedDataException {
        Validation.validate((Object)proto, (Matcher)IsNull.notNullValue(), MalformedDataException.class);
        return new Builder(proto).build();
    }

    private CredentialRetrieveResult(Builder builder) {
        this.mResultCode = builder.mResultCode;
        this.mCredential = builder.mCredential;
        this.mAdditionalProps = Collections.unmodifiableMap(builder.mAdditionalProps);
    }

    public boolean isSuccessful() {
        return 2 == this.mResultCode;
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    @Nullable
    public Credential getCredential() {
        return this.mCredential;
    }

    @Override
    @NonNull
    public Map<String, byte[]> getAdditionalProperties() {
        return AdditionalPropertiesUtil.convertValuesToByteArrays(this.mAdditionalProps);
    }

    @Override
    @Nullable
    public byte[] getAdditionalProperty(String key) {
        return AdditionalPropertiesUtil.getPropertyValue(this.mAdditionalProps, key);
    }

    @Override
    @Nullable
    public String getAdditionalPropertyAsString(String key) {
        return AdditionalPropertiesUtil.getPropertyValueAsString(this.mAdditionalProps, key);
    }

    public Protobufs.CredentialRetrieveResult toProtobuf() {
        Protobufs.CredentialRetrieveResult.Builder builder = Protobufs.CredentialRetrieveResult.newBuilder().setResultCodeValue(this.mResultCode).putAllAdditionalProps(this.mAdditionalProps);
        if (this.mCredential != null) {
            builder.setCredential(this.mCredential.toProtobuf());
        }
        return (Protobufs.CredentialRetrieveResult)builder.build();
    }

    public Intent toResultDataIntent() {
        Intent intent = new Intent();
        intent.putExtra("org.openyolo.credential.retrieve.result", this.toProtobuf().toByteArray());
        return intent;
    }

    public static final class Builder
    implements AdditionalPropertiesBuilder<CredentialRetrieveResult, Builder> {
        private int mResultCode;
        private Credential mCredential;
        private Map<String, ByteString> mAdditionalProps = new HashMap<String, ByteString>();

        public Builder(int resultCode) {
            this.setResultCode(resultCode);
        }

        private Builder(Protobufs.CredentialRetrieveResult proto) throws MalformedDataException {
            Validation.validate((Object)proto, (Matcher)IsNull.notNullValue(), MalformedDataException.class);
            try {
                this.setResultCode(proto.getResultCodeValue());
                this.setCredentialFromProto(proto.getCredential());
                this.setAdditionalPropertiesFromProto(proto.getAdditionalPropsMap());
            }
            catch (IllegalArgumentException ex) {
                throw new MalformedDataException(ex);
            }
        }

        public Builder setResultCode(int resultCode) {
            this.mResultCode = resultCode;
            return this;
        }

        public Builder setCredential(@Nullable Credential credential) {
            this.mCredential = credential;
            return this;
        }

        private Builder setCredentialFromProto(@Nullable Protobufs.Credential credential) throws MalformedDataException {
            this.mCredential = null == credential || Protobufs.Credential.getDefaultInstance().equals(credential) ? null : Credential.fromProtobuf(credential);
            return this;
        }

        @Override
        @NonNull
        public Builder setAdditionalProperties(Map<String, byte[]> additionalProperties) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalProperties(additionalProperties);
            return this;
        }

        private Builder setAdditionalPropertiesFromProto(Map<String, ByteString> additionalProperties) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalPropertiesFromProto(additionalProperties);
            return this;
        }

        @Override
        @NonNull
        public Builder setAdditionalProperty(@NonNull String key, @Nullable byte[] value) {
            AdditionalPropertiesUtil.setPropertyValue(this.mAdditionalProps, key, value);
            return this;
        }

        @Override
        @NonNull
        public Builder setAdditionalPropertyAsString(@NonNull String key, @Nullable String value) {
            AdditionalPropertiesUtil.setPropertyValueAsString(this.mAdditionalProps, key, value);
            return this;
        }

        @Override
        @NonNull
        public CredentialRetrieveResult build() {
            return new CredentialRetrieveResult(this);
        }
    }
}

