/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.openyolo.protocol.AdditionalPropertiesBuilder;
import org.openyolo.protocol.AdditionalPropertiesContainer;
import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.internal.AdditionalPropertiesUtil;
import org.openyolo.protocol.internal.IntentProtocolBufferExtractor;
import org.valid4j.Validation;

public final class CredentialDeleteResult
implements AdditionalPropertiesContainer {
    public static final int CODE_UNKNOWN = 0;
    public static final int CODE_NO_PROVIDER_AVAILABLE = 7;
    public static final int CODE_BAD_REQUEST = 1;
    public static final int CODE_DELETED = 2;
    public static final int CODE_NO_MATCHING_CREDENTIAL = 3;
    public static final int CODE_PROVIDER_REFUSED = 4;
    public static final int CODE_USER_CANCELED = 5;
    public static final int CODE_USER_REFUSED = 6;
    public static final CredentialDeleteResult UNKNOWN = new Builder(0).build();
    public static final CredentialDeleteResult NO_PROVIDER_AVAILABLE = new Builder(7).build();
    public static final CredentialDeleteResult BAD_REQUEST = new Builder(1).build();
    public static final CredentialDeleteResult DELETED = new Builder(2).build();
    public static final CredentialDeleteResult NO_MATCHING_CREDENTIAL = new Builder(3).build();
    public static final CredentialDeleteResult PROVIDER_REFUSED = new Builder(4).build();
    public static final CredentialDeleteResult USER_CANCELED = new Builder(5).build();
    public static final CredentialDeleteResult USER_REFUSED = new Builder(6).build();
    private static final String UNABLE_TO_EXTRACT_RESULT = "Unable to extract or parse the credential deletion result";
    private final int mResultCode;
    @NonNull
    private final Map<String, ByteString> mAdditionalProps;

    public static CredentialDeleteResult fromProtobuf(Protobufs.CredentialDeleteResult proto) throws MalformedDataException {
        Validation.validate((Object)proto, (Matcher)IsNull.notNullValue(), IllegalArgumentException.class);
        return new Builder(proto).build();
    }

    public static CredentialDeleteResult fromProtobufBytes(@Nullable byte[] protoBytes) throws MalformedDataException {
        Validation.validate((Object)protoBytes, (Matcher)IsNull.notNullValue(), MalformedDataException.class);
        try {
            return CredentialDeleteResult.fromProtobuf(Protobufs.CredentialDeleteResult.parseFrom(protoBytes));
        }
        catch (InvalidProtocolBufferException ex) {
            throw new MalformedDataException(ex);
        }
    }

    public static CredentialDeleteResult fromResultIntentData(@Nullable Intent intent) throws MalformedDataException {
        return CredentialDeleteResult.fromProtobuf(IntentProtocolBufferExtractor.extract("org.openyolo.credential.delete.result", Protobufs.CredentialDeleteResult.parser(), UNABLE_TO_EXTRACT_RESULT, intent));
    }

    private CredentialDeleteResult(Builder builder) {
        this.mResultCode = builder.mResultCode;
        this.mAdditionalProps = Collections.unmodifiableMap(builder.mAdditionalProps);
    }

    public boolean isSuccessful() {
        return 2 == this.mResultCode;
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    @Override
    @NonNull
    public Map<String, byte[]> getAdditionalProperties() {
        return AdditionalPropertiesUtil.convertValuesToByteArrays(this.mAdditionalProps);
    }

    @Override
    @Nullable
    public byte[] getAdditionalProperty(String key) {
        return AdditionalPropertiesUtil.getPropertyValue(this.mAdditionalProps, key);
    }

    @Override
    @Nullable
    public String getAdditionalPropertyAsString(String key) {
        return AdditionalPropertiesUtil.getPropertyValueAsString(this.mAdditionalProps, key);
    }

    public Protobufs.CredentialDeleteResult toProtobuf() {
        return (Protobufs.CredentialDeleteResult)Protobufs.CredentialDeleteResult.newBuilder().setResultCodeValue(this.mResultCode).putAllAdditionalProps(this.mAdditionalProps).build();
    }

    public Intent toResultDataIntent() {
        Intent resultData = new Intent();
        resultData.putExtra("org.openyolo.credential.delete.result", this.toProtobuf().toByteArray());
        return resultData;
    }

    public static final class Builder
    implements AdditionalPropertiesBuilder<CredentialDeleteResult, Builder> {
        private int mResultCode;
        @NonNull
        private Map<String, ByteString> mAdditionalProps = new HashMap<String, ByteString>();

        private Builder(Protobufs.CredentialDeleteResult proto) throws MalformedDataException {
            try {
                this.setResultCode(proto.getResultCodeValue());
                this.setAdditionalPropertiesFromProto(proto.getAdditionalPropsMap());
            }
            catch (IllegalArgumentException ex) {
                throw new MalformedDataException(ex);
            }
        }

        public Builder(int resultCode) {
            this.setResultCode(resultCode);
        }

        public Builder setResultCode(int resultCode) {
            this.mResultCode = resultCode;
            return this;
        }

        @Override
        @NonNull
        public Builder setAdditionalProperties(@Nullable Map<String, byte[]> additionalProperties) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalProperties(additionalProperties);
            return this;
        }

        @Override
        @NonNull
        public Builder setAdditionalProperty(@NonNull String key, @Nullable byte[] value) {
            AdditionalPropertiesUtil.setPropertyValue(this.mAdditionalProps, key, value);
            return this;
        }

        @Override
        @NonNull
        public Builder setAdditionalPropertyAsString(@NonNull String key, @Nullable String value) {
            AdditionalPropertiesUtil.setPropertyValueAsString(this.mAdditionalProps, key, value);
            return this;
        }

        private Builder setAdditionalPropertiesFromProto(Map<String, ByteString> additionalProperties) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalPropertiesFromProto(additionalProperties);
            return this;
        }

        @Override
        @NonNull
        public CredentialDeleteResult build() {
            return new CredentialDeleteResult(this);
        }
    }
}

