/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openyolo.protocol.AdditionalPropertiesBuilder;
import org.openyolo.protocol.AdditionalPropertiesContainer;
import org.openyolo.protocol.Credential;
import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.internal.AdditionalPropertiesUtil;
import org.openyolo.protocol.internal.ClientVersionUtil;
import org.openyolo.protocol.internal.IntentProtocolBufferExtractor;
import org.valid4j.Validation;

public final class CredentialDeleteRequest
implements AdditionalPropertiesContainer {
    @NonNull
    private final Credential mCredential;
    @NonNull
    private final Map<String, ByteString> mAdditionalProps;

    public static CredentialDeleteRequest fromCredential(Credential credential) {
        return new Builder(credential).build();
    }

    public static CredentialDeleteRequest fromProtobufBytes(@NonNull byte[] protobufBytes) throws MalformedDataException {
        Validation.validate((Object)protobufBytes, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
        try {
            return CredentialDeleteRequest.fromProtobuf(Protobufs.CredentialDeleteRequest.parseFrom(protobufBytes));
        }
        catch (InvalidProtocolBufferException ex) {
            throw new MalformedDataException("unable to parse credential deletion request", ex);
        }
    }

    public static CredentialDeleteRequest fromProtobuf(@NonNull Protobufs.CredentialDeleteRequest proto) throws MalformedDataException {
        Validation.validate((Object)proto, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
        return new Builder(proto).build();
    }

    public static CredentialDeleteRequest fromRequestIntent(@Nullable Intent requestIntent) throws MalformedDataException {
        return CredentialDeleteRequest.fromProtobuf(IntentProtocolBufferExtractor.extract("org.openyolo.credential.delete.request", Protobufs.CredentialDeleteRequest.parser(), "deletion request missing or contains invalid data", requestIntent));
    }

    private CredentialDeleteRequest(Builder builder) {
        this.mCredential = builder.mCredential;
        this.mAdditionalProps = Collections.unmodifiableMap(builder.mAdditionalProps);
    }

    @NonNull
    public Credential getCredential() {
        return this.mCredential;
    }

    @Override
    @NonNull
    public Map<String, byte[]> getAdditionalProperties() {
        return AdditionalPropertiesUtil.convertValuesToByteArrays(this.mAdditionalProps);
    }

    @Override
    @Nullable
    public byte[] getAdditionalProperty(String key) {
        return AdditionalPropertiesUtil.getPropertyValue(this.mAdditionalProps, key);
    }

    @Override
    @Nullable
    public String getAdditionalPropertyAsString(String key) {
        return AdditionalPropertiesUtil.getPropertyValueAsString(this.mAdditionalProps, key);
    }

    public Protobufs.CredentialDeleteRequest toProtobuf() {
        return (Protobufs.CredentialDeleteRequest)Protobufs.CredentialDeleteRequest.newBuilder().setClientVersion(ClientVersionUtil.getClientVersion()).setCredential(this.mCredential.toProtobuf()).putAllAdditionalProps(this.mAdditionalProps).build();
    }

    public static final class Builder
    implements AdditionalPropertiesBuilder<CredentialDeleteRequest, Builder> {
        @NonNull
        private Credential mCredential;
        @NonNull
        private Map<String, ByteString> mAdditionalProps = new HashMap<String, ByteString>();

        private Builder(Protobufs.CredentialDeleteRequest proto) throws MalformedDataException {
            try {
                this.setCredential(Credential.fromProtobuf(proto.getCredential()));
                this.setAdditionalPropertiesFromProto(proto.getAdditionalPropsMap());
            }
            catch (IllegalArgumentException ex) {
                throw new MalformedDataException(ex);
            }
        }

        public Builder(@NonNull Credential credential) {
            this.setCredential(credential);
        }

        public Builder setCredential(@NonNull Credential credential) {
            Validation.validate((Object)credential, (Matcher)CoreMatchers.notNullValue(), IllegalArgumentException.class);
            this.mCredential = credential;
            return this;
        }

        @Override
        @NonNull
        public Builder setAdditionalProperties(@Nullable Map<String, byte[]> additionalProperties) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalProperties(additionalProperties);
            return this;
        }

        @Override
        @NonNull
        public Builder setAdditionalProperty(@NonNull String key, @Nullable byte[] value) {
            AdditionalPropertiesUtil.setPropertyValue(this.mAdditionalProps, key, value);
            return this;
        }

        @Override
        @NonNull
        public Builder setAdditionalPropertyAsString(@NonNull String key, @Nullable String value) {
            AdditionalPropertiesUtil.setPropertyValueAsString(this.mAdditionalProps, key, value);
            return this;
        }

        private Builder setAdditionalPropertiesFromProto(Map<String, ByteString> additionalProperties) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalPropertiesFromProto(additionalProperties);
            return this;
        }

        @Override
        @NonNull
        public CredentialDeleteRequest build() {
            return new CredentialDeleteRequest(this);
        }
    }
}

