/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.openyolo.protocol.AdditionalPropertiesBuilder;
import org.openyolo.protocol.AdditionalPropertiesContainer;
import org.openyolo.protocol.AuthenticationMethod;
import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.PasswordSpecification;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.TokenRequestInfo;
import org.openyolo.protocol.internal.AdditionalPropertiesUtil;
import org.openyolo.protocol.internal.AuthenticationMethodConverters;
import org.openyolo.protocol.internal.ByteStringConverters;
import org.openyolo.protocol.internal.ClientVersionUtil;
import org.openyolo.protocol.internal.CollectionConverter;
import org.openyolo.protocol.internal.CustomMatchers;
import org.openyolo.protocol.internal.NoopValueConverter;
import org.openyolo.protocol.internal.TokenRequestInfoConverters;
import org.valid4j.Validation;

public class HintRetrieveRequest
implements Parcelable,
AdditionalPropertiesContainer {
    public static final Parcelable.Creator<HintRetrieveRequest> CREATOR = new HintRequestCreator();
    @NonNull
    private final Set<AuthenticationMethod> mAuthMethods;
    @NonNull
    private final Map<String, TokenRequestInfo> mTokenProviders;
    @NonNull
    private final PasswordSpecification mPasswordSpec;
    @NonNull
    private final Map<String, ByteString> mAdditionalProperties;

    public static HintRetrieveRequest fromAuthMethods(AuthenticationMethod ... authenticationMethods) {
        return new Builder(authenticationMethods).build();
    }

    public static HintRetrieveRequest fromAuthMethods(Set<AuthenticationMethod> authenticationMethods) {
        return new Builder(authenticationMethods).build();
    }

    @NonNull
    public static HintRetrieveRequest fromProtoBytes(byte[] hintRequestProtoBytes) throws MalformedDataException {
        Validation.validate((Object)hintRequestProtoBytes, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
        try {
            return HintRetrieveRequest.fromProtobuf(Protobufs.HintRetrieveRequest.parseFrom(hintRequestProtoBytes));
        }
        catch (IOException ex) {
            throw new MalformedDataException(ex);
        }
    }

    @NonNull
    public static HintRetrieveRequest fromProtobuf(Protobufs.HintRetrieveRequest protobuf) throws MalformedDataException {
        Validation.validate((Object)protobuf, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
        return new Builder(protobuf).build();
    }

    private HintRetrieveRequest(@NonNull Builder builder) {
        this.mAuthMethods = Collections.unmodifiableSet(builder.mAuthMethods);
        this.mTokenProviders = Collections.unmodifiableMap(builder.mTokenProviders);
        this.mPasswordSpec = builder.mPasswordSpec;
        this.mAdditionalProperties = Collections.unmodifiableMap(builder.mAdditionalProps);
    }

    @NonNull
    public Set<AuthenticationMethod> getAuthenticationMethods() {
        return this.mAuthMethods;
    }

    @NonNull
    public Map<String, TokenRequestInfo> getTokenProviders() {
        return this.mTokenProviders;
    }

    @NonNull
    public PasswordSpecification getPasswordSpecification() {
        return this.mPasswordSpec;
    }

    @Override
    @NonNull
    public Map<String, byte[]> getAdditionalProperties() {
        return AdditionalPropertiesUtil.convertValuesToByteArrays(this.mAdditionalProperties);
    }

    @Override
    @Nullable
    public byte[] getAdditionalProperty(String key) {
        return AdditionalPropertiesUtil.getPropertyValue(this.mAdditionalProperties, key);
    }

    @Override
    @Nullable
    public String getAdditionalPropertyAsString(String key) {
        return AdditionalPropertiesUtil.getPropertyValueAsString(this.mAdditionalProperties, key);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        byte[] protoBytes = this.toProtocolBuffer().toByteArray();
        dest.writeInt(protoBytes.length);
        dest.writeByteArray(protoBytes);
    }

    @NonNull
    public Protobufs.HintRetrieveRequest toProtocolBuffer() {
        return (Protobufs.HintRetrieveRequest)Protobufs.HintRetrieveRequest.newBuilder().setClientVersion(ClientVersionUtil.getClientVersion()).addAllAuthMethods(CollectionConverter.toList(this.mAuthMethods, AuthenticationMethodConverters.OBJECT_TO_PROTOBUF)).putAllSupportedTokenProviders(CollectionConverter.convertMapValues(this.mTokenProviders, TokenRequestInfoConverters.OBJECT_TO_PROTOBUF)).putAllAdditionalProps(this.mAdditionalProperties).setPasswordSpec(this.mPasswordSpec.toProtocolBuffer()).build();
    }

    private static final class HintRequestCreator
    implements Parcelable.Creator<HintRetrieveRequest> {
        private HintRequestCreator() {
        }

        public HintRetrieveRequest createFromParcel(Parcel in) {
            int protoLength = in.readInt();
            byte[] protoBytes = new byte[protoLength];
            in.readByteArray(protoBytes);
            try {
                return HintRetrieveRequest.fromProtoBytes(protoBytes);
            }
            catch (MalformedDataException ex) {
                throw new IllegalStateException("Unable to read proto from parcel", ex);
            }
        }

        public HintRetrieveRequest[] newArray(int size) {
            return new HintRetrieveRequest[size];
        }
    }

    public static final class Builder
    implements AdditionalPropertiesBuilder<HintRetrieveRequest, Builder> {
        private Set<AuthenticationMethod> mAuthMethods = new HashSet<AuthenticationMethod>();
        private Map<String, ByteString> mAdditionalProps = new HashMap<String, ByteString>();
        private Map<String, TokenRequestInfo> mTokenProviders = new HashMap<String, TokenRequestInfo>();
        private PasswordSpecification mPasswordSpec = PasswordSpecification.DEFAULT;

        private Builder(@NonNull Protobufs.HintRetrieveRequest requestProto) throws MalformedDataException {
            Validation.validate((Object)requestProto, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
            try {
                this.setAuthenticationMethods(CollectionConverter.toSet(requestProto.getAuthMethodsList(), AuthenticationMethodConverters.PROTOBUF_TO_OBJECT));
                this.setTokenProviders(CollectionConverter.convertMapValues(requestProto.getSupportedTokenProvidersMap(), TokenRequestInfoConverters.PROTOBUF_TO_OBJECT));
                this.setPasswordSpecification(PasswordSpecification.fromProtobuf(requestProto.getPasswordSpec()));
                this.setAdditionalProperties((Map)CollectionConverter.convertMapValues(requestProto.getAdditionalPropsMap(), ByteStringConverters.BYTE_STRING_TO_BYTE_ARRAY));
            }
            catch (IllegalArgumentException ex) {
                throw new MalformedDataException(ex);
            }
        }

        public Builder(AuthenticationMethod ... additionalAuthMethods) {
            this.setAuthenticationMethods(additionalAuthMethods);
        }

        public Builder(@NonNull Set<AuthenticationMethod> authMethods) {
            this.setAuthenticationMethods(authMethods);
        }

        @NonNull
        public Builder setAuthenticationMethods(AuthenticationMethod ... authenticationMethods) {
            this.setAuthenticationMethods(CollectionConverter.toSet(authenticationMethods, NoopValueConverter.getInstance()));
            return this;
        }

        @NonNull
        public Builder setAuthenticationMethods(@NonNull Set<AuthenticationMethod> authMethods) {
            Validation.validate(authMethods, (Matcher)CoreMatchers.notNullValue(), IllegalArgumentException.class);
            Validation.validate(authMethods, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.nullValue())), IllegalArgumentException.class);
            Validation.validate(authMethods, (Matcher)CoreMatchers.not((Matcher)IsEqual.equalTo((Object)Collections.EMPTY_SET)), IllegalArgumentException.class);
            this.mAuthMethods = authMethods;
            return this;
        }

        @NonNull
        public Builder addAuthenticationMethod(@NonNull AuthenticationMethod authenticationMethod) {
            Validation.validate((Object)authenticationMethod, (Matcher)CoreMatchers.notNullValue(), IllegalArgumentException.class);
            this.mAuthMethods.add(authenticationMethod);
            return this;
        }

        public Builder setTokenProviders(@Nullable Map<String, TokenRequestInfo> tokenProviders) {
            if (tokenProviders == null) {
                this.mTokenProviders.clear();
                return this;
            }
            for (Map.Entry<String, TokenRequestInfo> entry : tokenProviders.entrySet()) {
                this.addTokenProvider(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder addTokenProvider(@NonNull String tokenProviderUri) {
            this.addTokenProvider(tokenProviderUri, TokenRequestInfo.DEFAULT);
            return this;
        }

        public Builder addTokenProvider(@NonNull String tokenProviderUri, @Nullable TokenRequestInfo info) {
            Validation.validate((Object)tokenProviderUri, CustomMatchers.isHttpsUriStr(), IllegalArgumentException.class);
            if (info == null) {
                info = TokenRequestInfo.DEFAULT;
            }
            this.mTokenProviders.put(tokenProviderUri, info);
            return this;
        }

        @Override
        @NonNull
        public Builder setAdditionalProperties(@Nullable Map<String, byte[]> additionalProps) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalProperties(additionalProps);
            return this;
        }

        @Override
        @NonNull
        public Builder setAdditionalProperty(@NonNull String key, @Nullable byte[] value) {
            AdditionalPropertiesUtil.setPropertyValue(this.mAdditionalProps, key, value);
            return this;
        }

        @Override
        @NonNull
        public Builder setAdditionalPropertyAsString(@NonNull String key, @Nullable String value) {
            AdditionalPropertiesUtil.setPropertyValueAsString(this.mAdditionalProps, key, value);
            return this;
        }

        @NonNull
        public Builder setPasswordSpecification(@NonNull PasswordSpecification passwordSpec) {
            Validation.validate((Object)passwordSpec, (Matcher)CoreMatchers.notNullValue(), IllegalArgumentException.class);
            this.mPasswordSpec = passwordSpec;
            return this;
        }

        @Override
        @NonNull
        public HintRetrieveRequest build() {
            return new HintRetrieveRequest(this);
        }
    }
}

