/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol.internal;

import android.content.Intent;
import android.os.BadParcelableException;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.protobuf.ByteString;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.valid4j.Assertive;
import org.valid4j.Validation;

public final class IntentUtil {
    private IntentUtil() {
        throw new IllegalStateException("not intended to be constructed");
    }

    @NonNull
    public static byte[] toBytes(@NonNull Intent intent) {
        Assertive.require((Object)intent, (Matcher)CoreMatchers.notNullValue());
        Parcel parcel = Parcel.obtain();
        parcel.writeParcelable((Parcelable)intent, 0);
        byte[] intentBytes = parcel.marshall();
        parcel.recycle();
        return intentBytes;
    }

    public static ByteString toByteString(@NonNull Intent intent) {
        Assertive.require((Object)intent, (Matcher)CoreMatchers.notNullValue());
        return ByteString.copyFrom((byte[])IntentUtil.toBytes(intent));
    }

    @NonNull
    public static Intent fromBytes(@NonNull byte[] intentBytes) throws BadParcelableException {
        Intent intent;
        Assertive.require((Object)intentBytes, (Matcher)CoreMatchers.notNullValue());
        try {
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall(intentBytes, 0, intentBytes.length);
            parcel.setDataPosition(0);
            intent = (Intent)parcel.readParcelable(IntentUtil.class.getClassLoader());
            parcel.recycle();
        }
        catch (Exception ex) {
            throw new BadParcelableException(ex);
        }
        Validation.validate((Object)intent, (Matcher)CoreMatchers.notNullValue(), BadParcelableException.class);
        return intent;
    }
}

