/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol.internal;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openyolo.protocol.internal.ValueConverter;

public final class CollectionConverter {
    @NonNull
    public static <T, U> Set<U> toSet(@Nullable Collection<T> values, @NonNull ValueConverter<T, U> valueConverter) {
        Set<T> result = CollectionConverter.createSet(values);
        CollectionConverter.convert(values, result, valueConverter);
        return result;
    }

    public static <T, U> Set<U> toSet(@Nullable T[] values, @NonNull ValueConverter<T, U> valueConverter) {
        return CollectionConverter.toSet(null, values, valueConverter);
    }

    @NonNull
    public static <T, U> Set<U> toSet(@Nullable T firstValue, @Nullable T[] additionalValues, @NonNull ValueConverter<T, U> valueConverter) {
        Set<T> result = CollectionConverter.createSet(firstValue, additionalValues);
        CollectionConverter.convert(firstValue, additionalValues, result, valueConverter);
        return result;
    }

    @NonNull
    public static <T, U> List<U> toList(@Nullable Collection<T> values, @NonNull ValueConverter<T, U> valueConverter) {
        List<T> result = CollectionConverter.createList(values);
        CollectionConverter.convert(values, result, valueConverter);
        return result;
    }

    @NonNull
    public static <T, U> List<U> toList(@Nullable T firstValue, @Nullable T[] values, @NonNull ValueConverter<T, U> valueConverter) {
        List<T> result = CollectionConverter.createList(firstValue, values);
        CollectionConverter.convert(firstValue, values, result, valueConverter);
        return result;
    }

    @NonNull
    public static <T, U, V> Map<U, V> toMap(@Nullable Collection<T> values, @NonNull ValueConverter<T, Pair<U, V>> valueConverter) {
        if (values == null) {
            return Collections.emptyMap();
        }
        Map<T, U> result = CollectionConverter.createMap(values.size());
        for (T value : values) {
            Pair<U, V> converted = valueConverter.convert(value);
            result.put(converted.first, converted.second);
        }
        return result;
    }

    @NonNull
    public static <K, V, U> Map<K, U> convertMapValues(@Nullable Map<K, V> map, @NonNull ValueConverter<V, U> valueConverter) {
        if (map == null) {
            return Collections.emptyMap();
        }
        Map result = CollectionConverter.createMap(map.size());
        for (K key : map.keySet()) {
            V value = map.get(key);
            U convertedValue = valueConverter.convert(value);
            result.put(key, convertedValue);
        }
        return result;
    }

    private static <T, U> void convert(@Nullable Collection<T> source, @NonNull Collection<U> target, @NonNull ValueConverter<T, U> valueConverter) {
        if (source == null) {
            return;
        }
        for (T value : source) {
            target.add(valueConverter.convert(value));
        }
    }

    private static <T, U> void convert(@Nullable T firstValue, @Nullable T[] additionalValues, @NonNull Collection<U> target, @NonNull ValueConverter<T, U> valueConverter) {
        if (firstValue == null && additionalValues == null) {
            return;
        }
        if (firstValue != null) {
            target.add(valueConverter.convert(firstValue));
        }
        if (additionalValues != null) {
            for (T value : additionalValues) {
                target.add(valueConverter.convert(value));
            }
        }
    }

    @NonNull
    private static <T> Set<T> createSet(Collection collection) {
        return CollectionConverter.createSet(collection != null ? collection.size() : 0);
    }

    @NonNull
    private static <T, U> Set<T> createSet(U firstValue, U[] values) {
        return CollectionConverter.createSet((firstValue != null ? 1 : 0) + (values != null ? values.length : 0));
    }

    @NonNull
    private static <T> Set<T> createSet(int size) {
        if (Build.VERSION.SDK_INT >= 23) {
            return new ArraySet(size);
        }
        return new HashSet();
    }

    @NonNull
    private static <T, U> List<T> createList(@Nullable Collection<U> values) {
        return CollectionConverter.createList(values != null ? values.size() : 0);
    }

    @NonNull
    private static <T, U> List<T> createList(@Nullable U firstValue, @Nullable U[] additionalValues) {
        return CollectionConverter.createList((firstValue != null ? 1 : 0) + (additionalValues != null ? additionalValues.length : 0));
    }

    @NonNull
    private static <T> List<T> createList(int size) {
        return new ArrayList(size);
    }

    @NonNull
    private static <T, U> Map<T, U> createMap(int size) {
        if (Build.VERSION.SDK_INT >= 23) {
            return new ArrayMap(size);
        }
        return new HashMap();
    }

    private CollectionConverter() {
        throw new IllegalStateException("not intended to be constructed");
    }
}

