/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.openyolo.protocol.Hint;
import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.internal.AdditionalPropertiesUtil;
import org.openyolo.protocol.internal.ByteStringConverters;
import org.openyolo.protocol.internal.CollectionConverter;
import org.valid4j.Validation;

public final class HintRetrieveResult {
    public static final int CODE_UNKNOWN = 0;
    public static final int CODE_NO_PROVIDER_AVAILABLE = 6;
    public static final int CODE_BAD_REQUEST = 1;
    public static final int CODE_HINT_SELECTED = 2;
    public static final int CODE_NO_HINTS_AVAILABLE = 3;
    public static final int CODE_USER_REQUESTS_MANUAL_AUTH = 4;
    public static final int CODE_USER_CANCELED = 5;
    public static final HintRetrieveResult UNKNOWN = new Builder(0).build();
    public static final HintRetrieveResult NO_PROVIDER_AVAILABLE = new Builder(6).build();
    public static final HintRetrieveResult BAD_REQUEST = new Builder(1).build();
    public static final HintRetrieveResult NO_HINTS_AVAILABLE = new Builder(3).build();
    public static final HintRetrieveResult USER_REQUESTS_MANUAL_AUTH = new Builder(4).build();
    public static final HintRetrieveResult USER_CANCELED = new Builder(5).build();
    private final int mResultCode;
    @Nullable
    private final Hint mHint;
    @NonNull
    private final Map<String, ByteString> mAdditionalProps;

    public static HintRetrieveResult fromProtobuf(Protobufs.HintRetrieveResult proto) throws MalformedDataException {
        return new Builder(proto).build();
    }

    public static HintRetrieveResult fromProtobufBytes(byte[] protoBytes) throws MalformedDataException {
        Validation.validate((Object)protoBytes, (Matcher)IsNull.notNullValue(), MalformedDataException.class);
        try {
            return HintRetrieveResult.fromProtobuf(Protobufs.HintRetrieveResult.parseFrom(protoBytes));
        }
        catch (IOException ex) {
            throw new MalformedDataException(ex);
        }
    }

    private HintRetrieveResult(Builder builder) {
        this.mResultCode = builder.mResultCode;
        this.mHint = builder.mHint;
        this.mAdditionalProps = Collections.unmodifiableMap(builder.mAdditionalProps);
    }

    public Protobufs.HintRetrieveResult toProtobuf() {
        Protobufs.HintRetrieveResult.Builder builder = Protobufs.HintRetrieveResult.newBuilder().setResultCodeValue(this.mResultCode).putAllAdditionalProps(this.mAdditionalProps);
        if (this.mHint != null) {
            builder.setHint(this.mHint.toProtobuf());
        }
        return (Protobufs.HintRetrieveResult)builder.build();
    }

    public Intent toResultDataIntent() {
        Intent intent = new Intent();
        intent.putExtra("org.openyolo.hint.result", this.toProtobuf().toByteArray());
        return intent;
    }

    public boolean isSuccessful() {
        return 2 == this.mResultCode;
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    @Nullable
    public Hint getHint() {
        return this.mHint;
    }

    @NonNull
    public Map<String, byte[]> getAdditionalProperties() {
        return CollectionConverter.convertMapValues(this.mAdditionalProps, ByteStringConverters.BYTE_STRING_TO_BYTE_ARRAY);
    }

    public static final class Builder {
        private int mResultCode;
        @Nullable
        private Hint mHint;
        @NonNull
        private Map<String, ByteString> mAdditionalProps = new HashMap<String, ByteString>();

        private Builder(@NonNull Protobufs.HintRetrieveResult proto) throws MalformedDataException {
            Validation.validate((Object)proto, (Matcher)IsNull.notNullValue(), MalformedDataException.class);
            try {
                this.setResultCode(proto.getResultCodeValue());
                this.setAdditionalPropertiesFromProto(proto.getAdditionalPropsMap());
                this.setHintFromProto(proto.getHint());
            }
            catch (IllegalArgumentException ex) {
                throw new MalformedDataException(ex);
            }
        }

        public Builder(int resultCode) {
            this.setResultCode(resultCode);
        }

        public Builder setResultCode(int resultCode) {
            this.mResultCode = resultCode;
            return this;
        }

        public Builder setHint(@Nullable Hint hint) {
            this.mHint = hint;
            return this;
        }

        private Builder setHintFromProto(@Nullable Protobufs.Hint hint) throws MalformedDataException {
            this.mHint = null == hint || Protobufs.Hint.getDefaultInstance().equals(hint) ? null : Hint.fromProtobuf(hint);
            return this;
        }

        public Builder setAdditionalProperties(Map<String, byte[]> additionalProps) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalProperties(additionalProps);
            return this;
        }

        private Builder setAdditionalPropertiesFromProto(Map<String, ByteString> additionalProps) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalPropertiesFromProto(additionalProps);
            return this;
        }

        public HintRetrieveResult build() {
            return new HintRetrieveResult(this);
        }
    }
}

