/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.content.Context;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openyolo.protocol.AuthenticationDomain;
import org.openyolo.protocol.AuthenticationMethod;
import org.openyolo.protocol.Credential;
import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.internal.AdditionalPropertiesUtil;
import org.openyolo.protocol.internal.ByteStringConverters;
import org.openyolo.protocol.internal.CollectionConverter;
import org.openyolo.protocol.internal.CustomMatchers;
import org.openyolo.protocol.internal.StringUtil;
import org.valid4j.Validation;

public final class Hint
implements Parcelable {
    public static final Parcelable.Creator<Hint> CREATOR = new HintCreator();
    @NonNull
    private final String mId;
    @NonNull
    private final AuthenticationMethod mAuthMethod;
    @Nullable
    private final String mDisplayName;
    @Nullable
    private final Uri mDisplayPictureUri;
    @Nullable
    private final String mGeneratedPassword;
    @Nullable
    private final String mIdToken;
    @NonNull
    private final Map<String, ByteString> mAdditionalProps;

    public static Hint fromProtobuf(Protobufs.Hint proto) throws MalformedDataException {
        return new Builder(proto).build();
    }

    public static Hint fromProtobufBytes(byte[] protoBytes) throws MalformedDataException {
        Validation.validate((Object)protoBytes, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
        try {
            return Hint.fromProtobuf(Protobufs.Hint.parseFrom(protoBytes));
        }
        catch (IOException ex) {
            throw new MalformedDataException(ex);
        }
    }

    private Hint(Builder builder) {
        this.mId = builder.mId;
        this.mAuthMethod = builder.mAuthMethod;
        this.mDisplayName = builder.mDisplayName;
        this.mDisplayPictureUri = builder.mDisplayPictureUri;
        this.mGeneratedPassword = builder.mGeneratedPassword;
        this.mIdToken = builder.mIdToken;
        this.mAdditionalProps = Collections.unmodifiableMap(builder.mAdditionalProps);
    }

    public Protobufs.Hint toProtobuf() {
        Protobufs.Hint.Builder builder = Protobufs.Hint.newBuilder().setId(this.mId).setAuthMethod(this.mAuthMethod.toProtobuf()).putAllAdditionalProps(this.mAdditionalProps);
        if (this.mDisplayName != null) {
            builder.setDisplayName(this.mDisplayName);
        }
        if (this.mDisplayPictureUri != null) {
            builder.setDisplayPictureUri(this.mDisplayPictureUri.toString());
        }
        if (this.mGeneratedPassword != null) {
            builder.setGeneratedPassword(this.mGeneratedPassword);
        }
        if (this.mIdToken != null) {
            builder.setIdToken(this.mIdToken);
        }
        return (Protobufs.Hint)builder.build();
    }

    public Credential.Builder toCredentialBuilder(Context context) {
        AuthenticationDomain authDomain = AuthenticationDomain.getSelfAuthDomain(context);
        return new Credential.Builder(this.mId, this.mAuthMethod, authDomain).setDisplayName(this.mDisplayName).setDisplayPicture(this.mDisplayPictureUri).setPassword(this.mGeneratedPassword).setIdToken(this.mIdToken).setAdditionalProperties(this.getAdditionalProperties());
    }

    @NonNull
    public String getIdentifier() {
        return this.mId;
    }

    @NonNull
    public AuthenticationMethod getAuthenticationMethod() {
        return this.mAuthMethod;
    }

    @Nullable
    public String getDisplayName() {
        return this.mDisplayName;
    }

    @Nullable
    public Uri getDisplayPicture() {
        return this.mDisplayPictureUri;
    }

    @Nullable
    public String getGeneratedPassword() {
        return this.mGeneratedPassword;
    }

    @Nullable
    public String getIdToken() {
        return this.mIdToken;
    }

    @NonNull
    public Map<String, byte[]> getAdditionalProperties() {
        return CollectionConverter.convertMapValues(this.mAdditionalProps, ByteStringConverters.BYTE_STRING_TO_BYTE_ARRAY);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        byte[] hintBytes = this.toProtobuf().toByteArray();
        dest.writeInt(hintBytes.length);
        dest.writeByteArray(hintBytes);
    }

    private static final class HintCreator
    implements Parcelable.Creator<Hint> {
        private HintCreator() {
        }

        public Hint createFromParcel(Parcel source) {
            int length = source.readInt();
            byte[] hintBytes = new byte[length];
            source.readByteArray(hintBytes);
            try {
                return Hint.fromProtobufBytes(hintBytes);
            }
            catch (MalformedDataException ex) {
                throw new IllegalArgumentException("Unable to parse hint from parcel", ex);
            }
        }

        public Hint[] newArray(int size) {
            return new Hint[size];
        }
    }

    public static final class Builder {
        @NonNull
        private String mId;
        @NonNull
        private AuthenticationMethod mAuthMethod;
        @Nullable
        private String mDisplayName;
        @Nullable
        private Uri mDisplayPictureUri;
        @Nullable
        private String mGeneratedPassword;
        @Nullable
        private String mIdToken;
        @NonNull
        private Map<String, ByteString> mAdditionalProps = new HashMap<String, ByteString>();

        public Builder(@NonNull String id, @NonNull AuthenticationMethod authMethod) {
            this.setIdentifier(id);
            this.setAuthMethod(authMethod);
        }

        public Builder(@NonNull String id, @NonNull String authMethod) {
            this(id, new AuthenticationMethod(authMethod));
        }

        public Builder(Hint hint) {
            this.setIdentifier(hint.mId);
            this.setAuthMethod(hint.mAuthMethod);
            this.setDisplayName(hint.mDisplayName);
            this.setDisplayPictureUri(hint.mDisplayPictureUri);
            this.setGeneratedPassword(hint.mGeneratedPassword);
            this.setIdToken(hint.mIdToken);
            this.setAdditionalPropertiesFromProto(hint.mAdditionalProps);
        }

        private Builder(@NonNull Protobufs.Hint proto) throws MalformedDataException {
            Validation.validate((Object)proto, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
            try {
                this.setIdentifier(proto.getId());
                this.setAuthMethod(proto.getAuthMethod().getUri());
                this.setDisplayName(proto.getDisplayName());
                this.setDisplayPictureUri(proto.getDisplayPictureUri());
                this.setGeneratedPassword(proto.getGeneratedPassword());
                this.setIdToken(proto.getIdToken());
                this.setAdditionalPropertiesFromProto(proto.getAdditionalPropsMap());
            }
            catch (IllegalArgumentException ex) {
                throw new MalformedDataException(ex);
            }
        }

        public Builder setIdentifier(@NonNull String id) {
            Validation.validate((Object)id, CustomMatchers.notNullOrEmptyString(), IllegalArgumentException.class);
            this.mId = id;
            return this;
        }

        public Builder setAuthMethod(@NonNull String authMethod) {
            Validation.validate((Object)authMethod, CustomMatchers.isValidAuthenticationMethod(), IllegalArgumentException.class);
            this.mAuthMethod = new AuthenticationMethod(authMethod);
            return this;
        }

        public Builder setAuthMethod(@NonNull AuthenticationMethod authMethod) {
            Validation.validate((Object)authMethod, (Matcher)CoreMatchers.notNullValue(), IllegalArgumentException.class);
            this.mAuthMethod = authMethod;
            return this;
        }

        public Builder setDisplayName(@Nullable String displayName) {
            this.mDisplayName = StringUtil.nullifyEmptyString(displayName);
            return this;
        }

        public Builder setDisplayPictureUri(@Nullable String displayPictureUri) {
            this.setDisplayPictureUri(StringUtil.nullifyEmptyString(displayPictureUri) != null ? Uri.parse((String)displayPictureUri) : null);
            return this;
        }

        public Builder setDisplayPictureUri(@Nullable Uri displayPictureUri) {
            Validation.validate((Object)displayPictureUri, CustomMatchers.nullOr(CustomMatchers.isWebUri()), IllegalArgumentException.class);
            this.mDisplayPictureUri = displayPictureUri;
            return this;
        }

        public Builder setGeneratedPassword(@Nullable String generatedPassword) {
            this.mGeneratedPassword = StringUtil.nullifyEmptyString(generatedPassword);
            return this;
        }

        public Builder setIdToken(@Nullable String idToken) {
            this.mIdToken = StringUtil.nullifyEmptyString(idToken);
            return this;
        }

        public Builder setAdditionalProperties(@Nullable Map<String, byte[]> additionalProps) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalProperties(additionalProps);
            return this;
        }

        private Builder setAdditionalPropertiesFromProto(@Nullable Map<String, ByteString> additionalProps) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalPropertiesFromProto(additionalProps);
            return this;
        }

        public Hint build() {
            return new Hint(this);
        }
    }
}

