/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.internal.AdditionalPropertiesUtil;
import org.openyolo.protocol.internal.ByteStringConverters;
import org.openyolo.protocol.internal.CollectionConverter;
import org.valid4j.Validation;

public final class CredentialSaveResult {
    public static final int CODE_UNKNOWN = 0;
    public static final int CODE_NO_PROVIDER_AVAILABLE = 6;
    public static final int CODE_BAD_REQUEST = 1;
    public static final int CODE_SAVED = 2;
    public static final int CODE_PROVIDER_REFUSED = 3;
    public static final int CODE_USER_CANCELED = 4;
    public static final int CODE_USER_REFUSED = 5;
    public static final CredentialSaveResult UNKNOWN = new Builder(0).build();
    public static final CredentialSaveResult NO_PROVIDER_AVAILABLE = new Builder(6).build();
    public static final CredentialSaveResult SAVED = new Builder(2).build();
    public static final CredentialSaveResult BAD_REQUEST = new Builder(1).build();
    public static final CredentialSaveResult USER_CANCELED = new Builder(4).build();
    public static final CredentialSaveResult USER_REFUSED = new Builder(5).build();
    public static final CredentialSaveResult PROVIDER_REFUSED = new Builder(3).build();
    private final int mResultCode;
    @NonNull
    private Map<String, ByteString> mAdditionalProperties;

    public static CredentialSaveResult fromProtobufBytes(byte[] protobufBytes) throws MalformedDataException {
        Validation.validate((Object)protobufBytes, (Matcher)IsNull.notNullValue(), MalformedDataException.class);
        try {
            return CredentialSaveResult.fromProtobuf(Protobufs.CredentialSaveResult.parseFrom(protobufBytes));
        }
        catch (IOException ex) {
            throw new MalformedDataException(ex);
        }
    }

    public static CredentialSaveResult fromProtobuf(Protobufs.CredentialSaveResult proto) throws MalformedDataException {
        Validation.validate((Object)proto, (Matcher)IsNull.notNullValue(), MalformedDataException.class);
        return new Builder(proto).build();
    }

    public Protobufs.CredentialSaveResult toProtobuf() {
        Protobufs.CredentialSaveResult.Builder builder = Protobufs.CredentialSaveResult.newBuilder().setResultCodeValue(this.mResultCode).putAllAdditionalProps(this.mAdditionalProperties);
        return (Protobufs.CredentialSaveResult)builder.build();
    }

    public Intent toResultDataIntent() {
        Intent intent = new Intent();
        intent.putExtra("org.openyolo.credential.save.result", this.toProtobuf().toByteArray());
        return intent;
    }

    private CredentialSaveResult(Builder builder) {
        this.mResultCode = builder.mResultCode;
        this.mAdditionalProperties = builder.mAdditionalProps;
    }

    public boolean isSuccessful() {
        return 2 == this.mResultCode;
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    @NonNull
    public Map<String, byte[]> getAdditionalProperties() {
        return CollectionConverter.convertMapValues(this.mAdditionalProperties, ByteStringConverters.BYTE_STRING_TO_BYTE_ARRAY);
    }

    public static final class Builder {
        private int mResultCode = 0;
        private Map<String, ByteString> mAdditionalProps = new HashMap<String, ByteString>();

        private Builder(Protobufs.CredentialSaveResult proto) throws MalformedDataException {
            Validation.validate((Object)proto, (Matcher)IsNull.notNullValue(), MalformedDataException.class);
            try {
                this.setResultCode(proto.getResultCodeValue());
                this.setAdditionalProperties(CollectionConverter.convertMapValues(proto.getAdditionalPropsMap(), ByteStringConverters.BYTE_STRING_TO_BYTE_ARRAY));
            }
            catch (IllegalArgumentException ex) {
                throw new MalformedDataException(ex);
            }
        }

        public Builder(int resultCode) {
            this.setResultCode(resultCode);
        }

        public Builder setResultCode(int resultCode) {
            this.mResultCode = resultCode;
            return this;
        }

        public Builder setAdditionalProperties(@Nullable Map<String, byte[]> additionalProps) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalProperties(additionalProps);
            return this;
        }

        public CredentialSaveResult build() {
            return new CredentialSaveResult(this);
        }
    }
}

