/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openyolo.protocol.AuthenticationMethod;
import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.TokenRequestInfo;
import org.openyolo.protocol.internal.AuthenticationMethodConverters;
import org.openyolo.protocol.internal.ByteStringConverters;
import org.openyolo.protocol.internal.ClientVersionUtil;
import org.openyolo.protocol.internal.CollectionConverter;
import org.openyolo.protocol.internal.CustomMatchers;
import org.openyolo.protocol.internal.NoopValueConverter;
import org.openyolo.protocol.internal.TokenRequestInfoConverters;
import org.valid4j.Validation;

public class CredentialRetrieveRequest
implements Parcelable {
    @VisibleForTesting
    static final Boolean DEFAULT_REQUIRE_USER_MEDIATION_VALUE = false;
    public static final Parcelable.Creator<CredentialRetrieveRequest> CREATOR = new RetrieveRequestCreator();
    @NonNull
    private final Set<AuthenticationMethod> mAuthMethods;
    @NonNull
    private final Map<String, TokenRequestInfo> mTokenProviders;
    @NonNull
    private final Map<String, byte[]> mAdditionalProps;
    @NonNull
    private final boolean mRequireUserMediation;

    @NonNull
    public static CredentialRetrieveRequest fromAuthMethods(@NonNull Set<AuthenticationMethod> authenticationMethods) {
        return new Builder(authenticationMethods).build();
    }

    @NonNull
    public static CredentialRetrieveRequest fromAuthMethods(AuthenticationMethod ... authenticationMethods) {
        return new Builder(authenticationMethods).build();
    }

    @NonNull
    public static CredentialRetrieveRequest fromProtobuf(@NonNull Protobufs.CredentialRetrieveRequest proto) throws MalformedDataException {
        Validation.validate((Object)proto, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
        return new Builder(proto).build();
    }

    @NonNull
    public static CredentialRetrieveRequest fromProtobufBytes(@NonNull byte[] protoBytes) throws MalformedDataException {
        Validation.validate((Object)protoBytes, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
        try {
            return CredentialRetrieveRequest.fromProtobuf(Protobufs.CredentialRetrieveRequest.parseFrom(protoBytes));
        }
        catch (IOException ex) {
            throw new MalformedDataException(ex);
        }
    }

    @NonNull
    public static CredentialRetrieveRequest fromRequestIntent(@NonNull Intent requestIntent) throws MalformedDataException {
        if (!requestIntent.hasExtra("org.openyolo.credential.retrieve.request")) {
            throw new MalformedDataException("credential retrieve request missing in intent data");
        }
        return CredentialRetrieveRequest.fromProtobufBytes(requestIntent.getByteArrayExtra("org.openyolo.credential.retrieve.request"));
    }

    private CredentialRetrieveRequest(Builder builder) {
        this.mAuthMethods = Collections.unmodifiableSet(builder.mAuthMethods);
        this.mTokenProviders = Collections.unmodifiableMap(builder.mTokenProviders);
        this.mAdditionalProps = Collections.unmodifiableMap(builder.mAdditionalParams);
        this.mRequireUserMediation = builder.mRequireUserMediation;
    }

    @NonNull
    public Set<AuthenticationMethod> getAuthenticationMethods() {
        return this.mAuthMethods;
    }

    @NonNull
    public Map<String, TokenRequestInfo> getTokenProviders() {
        return this.mTokenProviders;
    }

    @NonNull
    public boolean getRequireUserMediation() {
        return this.mRequireUserMediation;
    }

    @NonNull
    public Map<String, byte[]> getAdditionalProperties() {
        return this.mAdditionalProps;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        byte[] protoBytes = this.toProtocolBuffer().toByteArray();
        dest.writeInt(protoBytes.length);
        dest.writeByteArray(protoBytes);
    }

    public Protobufs.CredentialRetrieveRequest toProtocolBuffer() {
        return (Protobufs.CredentialRetrieveRequest)Protobufs.CredentialRetrieveRequest.newBuilder().setClientVersion(ClientVersionUtil.getClientVersion()).addAllAuthMethods(CollectionConverter.toList(this.mAuthMethods, AuthenticationMethodConverters.OBJECT_TO_PROTOBUF)).putAllSupportedTokenProviders(CollectionConverter.convertMapValues(this.mTokenProviders, TokenRequestInfoConverters.OBJECT_TO_PROTOBUF)).putAllAdditionalProps(CollectionConverter.convertMapValues(this.mAdditionalProps, ByteStringConverters.BYTE_ARRAY_TO_BYTE_STRING)).setRequireUserMediation(this.mRequireUserMediation).build();
    }

    private static final class RetrieveRequestCreator
    implements Parcelable.Creator<CredentialRetrieveRequest> {
        private RetrieveRequestCreator() {
        }

        public CredentialRetrieveRequest createFromParcel(Parcel in) {
            int protoLength = in.readInt();
            byte[] protoBytes = new byte[protoLength];
            in.readByteArray(protoBytes);
            try {
                return CredentialRetrieveRequest.fromProtobufBytes(protoBytes);
            }
            catch (MalformedDataException ex) {
                throw new IllegalStateException("Unable to read proto from parcel", ex);
            }
        }

        public CredentialRetrieveRequest[] newArray(int size) {
            return new CredentialRetrieveRequest[size];
        }
    }

    public static final class Builder {
        private Set<AuthenticationMethod> mAuthMethods = new HashSet<AuthenticationMethod>();
        private Map<String, TokenRequestInfo> mTokenProviders = new HashMap<String, TokenRequestInfo>();
        private Map<String, byte[]> mAdditionalParams = new HashMap<String, byte[]>();
        private boolean mRequireUserMediation = DEFAULT_REQUIRE_USER_MEDIATION_VALUE;

        public Builder(CredentialRetrieveRequest request) {
            this.mAuthMethods = request.mAuthMethods;
            this.mTokenProviders = request.mTokenProviders;
            this.mAdditionalParams = request.mAdditionalProps;
            this.mRequireUserMediation = request.mRequireUserMediation;
        }

        private Builder(@NonNull Protobufs.CredentialRetrieveRequest requestProto) throws MalformedDataException {
            Validation.validate((Object)requestProto, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
            try {
                this.setAuthenticationMethods(CollectionConverter.toSet(requestProto.getAuthMethodsList(), AuthenticationMethodConverters.PROTOBUF_TO_OBJECT));
                this.setTokenProviders(CollectionConverter.convertMapValues(requestProto.getSupportedTokenProvidersMap(), TokenRequestInfoConverters.PROTOBUF_TO_OBJECT));
                this.setAdditionalProperties(CollectionConverter.convertMapValues(requestProto.getAdditionalPropsMap(), ByteStringConverters.BYTE_STRING_TO_BYTE_ARRAY));
                this.setRequireUserMediation(requestProto.getRequireUserMediation());
            }
            catch (IllegalArgumentException ex) {
                throw new MalformedDataException(ex);
            }
        }

        public Builder(AuthenticationMethod ... authMethods) {
            this.setAuthenticationMethods(CollectionConverter.toSet(authMethods, NoopValueConverter.getInstance()));
        }

        public Builder(@NonNull Set<AuthenticationMethod> authMethods) {
            this.setAuthenticationMethods(authMethods);
        }

        private Builder setAuthenticationMethods(@NonNull Set<AuthenticationMethod> authMethods) {
            Validation.validate(authMethods, (Matcher)CoreMatchers.notNullValue(), IllegalArgumentException.class);
            Validation.validate(authMethods, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.nullValue())), IllegalArgumentException.class);
            Validation.validate(authMethods, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)Collections.EMPTY_SET)), IllegalArgumentException.class);
            this.mAuthMethods = authMethods;
            return this;
        }

        public Builder setRequireUserMediation(boolean value) {
            this.mRequireUserMediation = value;
            return this;
        }

        public Builder setTokenProviders(@Nullable Map<String, TokenRequestInfo> tokenProviders) {
            if (tokenProviders == null) {
                this.mTokenProviders.clear();
                return this;
            }
            for (Map.Entry<String, TokenRequestInfo> entry : tokenProviders.entrySet()) {
                this.addTokenProvider(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder addTokenProvider(@NonNull String tokenProviderUri) {
            this.addTokenProvider(tokenProviderUri, TokenRequestInfo.DEFAULT);
            return this;
        }

        public Builder addTokenProvider(@NonNull String tokenProviderUri, @Nullable TokenRequestInfo info) {
            Validation.validate((Object)tokenProviderUri, CustomMatchers.isHttpsUriStr(), IllegalArgumentException.class);
            if (info == null) {
                info = TokenRequestInfo.DEFAULT;
            }
            this.mTokenProviders.put(tokenProviderUri, info);
            return this;
        }

        public Builder setAdditionalProperties(@NonNull Map<String, byte[]> additionalParams) {
            Validation.validate(additionalParams, (Matcher)CoreMatchers.notNullValue(), IllegalArgumentException.class);
            Validation.validate(additionalParams.keySet(), (Matcher)CoreMatchers.everyItem(CustomMatchers.notNullOrEmptyString()), IllegalArgumentException.class);
            Validation.validate(additionalParams.values(), (Matcher)CoreMatchers.everyItem((Matcher)CoreMatchers.notNullValue()), IllegalArgumentException.class);
            this.mAdditionalParams = additionalParams;
            return this;
        }

        @NonNull
        public CredentialRetrieveRequest build() {
            return new CredentialRetrieveRequest(this);
        }
    }
}

