/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openyolo.protocol.AuthenticationDomain;
import org.openyolo.protocol.AuthenticationMethod;
import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.internal.AdditionalPropertiesUtil;
import org.openyolo.protocol.internal.ByteStringConverters;
import org.openyolo.protocol.internal.CollectionConverter;
import org.openyolo.protocol.internal.CustomMatchers;
import org.openyolo.protocol.internal.StringUtil;
import org.valid4j.Validation;

public final class Credential
implements Parcelable {
    public static final Parcelable.Creator<Credential> CREATOR = new CredentialCreator();
    @NonNull
    private final String mId;
    @NonNull
    private final AuthenticationDomain mAuthDomain;
    @NonNull
    private final AuthenticationMethod mAuthMethod;
    @Nullable
    private final String mDisplayName;
    @Nullable
    private final Uri mDisplayPicture;
    @Nullable
    private final String mPassword;
    @Nullable
    private final String mIdToken;
    @NonNull
    private final Map<String, ByteString> mAdditionalProps;

    public static Credential fromProtoBytes(@NonNull byte[] credentialProtoBytes) throws MalformedDataException {
        Validation.validate((Object)credentialProtoBytes, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
        try {
            return Credential.fromProtobuf(Protobufs.Credential.parseFrom(credentialProtoBytes));
        }
        catch (InvalidProtocolBufferException ex) {
            throw new MalformedDataException(ex);
        }
    }

    public static Credential fromProtobuf(Protobufs.Credential credential) throws MalformedDataException {
        return new Builder(credential).build();
    }

    private Credential(Builder builder) {
        this.mId = builder.mId;
        this.mAuthDomain = builder.mAuthDomain;
        this.mAuthMethod = builder.mAuthMethod;
        this.mDisplayName = builder.mDisplayName;
        this.mDisplayPicture = builder.mDisplayPicture;
        this.mPassword = builder.mPassword;
        this.mIdToken = builder.mIdToken;
        this.mAdditionalProps = Collections.unmodifiableMap(builder.mAdditionalProps);
    }

    @NonNull
    public Protobufs.Credential toProtobuf() {
        Protobufs.Credential.Builder builder = Protobufs.Credential.newBuilder().setId(this.mId).setAuthMethod(this.mAuthMethod.toProtobuf()).setAuthDomain(this.mAuthDomain.toProtobuf()).putAllAdditionalProps(this.mAdditionalProps);
        if (this.mDisplayName != null) {
            builder.setDisplayName(this.mDisplayName);
        }
        if (this.mDisplayPicture != null) {
            builder.setDisplayPictureUri(this.mDisplayPicture.toString());
        }
        if (this.mPassword != null) {
            builder.setPassword(this.mPassword);
        }
        if (this.mIdToken != null) {
            builder.setIdToken(this.mIdToken);
        }
        return (Protobufs.Credential)builder.build();
    }

    @NonNull
    public String getIdentifier() {
        return this.mId;
    }

    @NonNull
    public AuthenticationMethod getAuthenticationMethod() {
        return this.mAuthMethod;
    }

    @NonNull
    public AuthenticationDomain getAuthenticationDomain() {
        return this.mAuthDomain;
    }

    @Nullable
    public String getDisplayName() {
        return this.mDisplayName;
    }

    @Nullable
    public Uri getDisplayPicture() {
        return this.mDisplayPicture;
    }

    @Nullable
    public String getPassword() {
        return this.mPassword;
    }

    @Nullable
    public String getIdToken() {
        return this.mIdToken;
    }

    @NonNull
    public Map<String, byte[]> getAdditionalProperties() {
        return CollectionConverter.convertMapValues(this.mAdditionalProps, ByteStringConverters.BYTE_STRING_TO_BYTE_ARRAY);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        byte[] encoded = this.toProtobuf().toByteArray();
        dest.writeInt(encoded.length);
        dest.writeByteArray(encoded);
    }

    private static final class CredentialCreator
    implements Parcelable.Creator<Credential> {
        private CredentialCreator() {
        }

        public Credential createFromParcel(Parcel source) {
            int encodedLength = source.readInt();
            byte[] encodedBytes = new byte[encodedLength];
            source.readByteArray(encodedBytes);
            try {
                return Credential.fromProtoBytes(encodedBytes);
            }
            catch (MalformedDataException ex) {
                throw new IllegalStateException("Unable to decode credential proto", ex);
            }
        }

        public Credential[] newArray(int size) {
            return new Credential[0];
        }
    }

    public static final class Builder {
        private String mId;
        private AuthenticationMethod mAuthMethod;
        private AuthenticationDomain mAuthDomain;
        private String mDisplayName;
        private Uri mDisplayPicture;
        private String mPassword;
        private String mIdToken;
        private Map<String, ByteString> mAdditionalProps = new HashMap<String, ByteString>();

        private Builder(@NonNull Protobufs.Credential proto) throws MalformedDataException {
            try {
                this.setIdentifier(proto.getId());
                this.setAuthenticationMethod(AuthenticationMethod.fromProtobuf(proto.getAuthMethod()));
                this.setAuthenticationDomain(AuthenticationDomain.fromProtobuf(proto.getAuthDomain()));
                this.setIdToken(proto.getIdToken());
                this.setDisplayName(proto.getDisplayName());
                this.setDisplayPicture(proto.getDisplayPictureUri());
                this.setPassword(proto.getPassword());
                this.setAdditionalProperties(CollectionConverter.convertMapValues(proto.getAdditionalPropsMap(), ByteStringConverters.BYTE_STRING_TO_BYTE_ARRAY));
            }
            catch (IllegalArgumentException ex) {
                throw new MalformedDataException(ex);
            }
        }

        public Builder(@NonNull String identifier, @NonNull AuthenticationMethod authenticationMethod, @NonNull AuthenticationDomain authenticationDomain) {
            this.setIdentifier(identifier);
            this.setAuthenticationMethod(authenticationMethod);
            this.setAuthenticationDomain(authenticationDomain);
        }

        public Builder(@NonNull String identifier, @NonNull String authenticationMethod, @NonNull String authenticationDomain) {
            this(identifier, new AuthenticationMethod(authenticationMethod), new AuthenticationDomain(authenticationDomain));
        }

        @NonNull
        public Builder setIdentifier(@NonNull String identifier) {
            Validation.validate((Object)identifier, CustomMatchers.notNullOrEmptyString(), IllegalArgumentException.class);
            this.mId = identifier;
            return this;
        }

        @NonNull
        public Builder setAuthenticationDomain(@NonNull AuthenticationDomain domain) {
            Validation.validate((Object)domain, (Matcher)CoreMatchers.notNullValue(), IllegalArgumentException.class);
            this.mAuthDomain = domain;
            return this;
        }

        @NonNull
        public Builder setAuthenticationMethod(@NonNull AuthenticationMethod authMethod) {
            Validation.validate((Object)authMethod, (Matcher)CoreMatchers.notNullValue(), IllegalArgumentException.class);
            this.mAuthMethod = authMethod;
            return this;
        }

        @NonNull
        public Builder setPassword(@Nullable String password) {
            this.mPassword = StringUtil.nullifyEmptyString(password);
            return this;
        }

        @NonNull
        public Builder setIdToken(String idToken) {
            this.mIdToken = StringUtil.nullifyEmptyString(idToken);
            return this;
        }

        @NonNull
        public Builder setDisplayName(@Nullable String displayName) {
            this.mDisplayName = StringUtil.nullifyEmptyString(displayName);
            return this;
        }

        @NonNull
        public Builder setDisplayPicture(@Nullable Uri displayPicture) {
            Validation.validate((Object)displayPicture, CustomMatchers.nullOr(CustomMatchers.isWebUri()), IllegalArgumentException.class);
            this.mDisplayPicture = displayPicture;
            return this;
        }

        @NonNull
        public Builder setDisplayPicture(@Nullable String displayPicture) {
            return this.setDisplayPicture(StringUtil.nullifyEmptyString(displayPicture) != null ? Uri.parse((String)displayPicture) : null);
        }

        public Builder setAdditionalProperties(@Nullable Map<String, byte[]> additionalProps) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalProperties(additionalProps);
            return this;
        }

        @NonNull
        public Credential build() {
            return new Credential(this);
        }
    }
}

