/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import android.util.Log;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.internal.CustomMatchers;
import org.valid4j.Validation;

@SuppressLint(value={"PackageManagerGetSignatures"})
public final class AuthenticationDomain
implements Comparable<AuthenticationDomain> {
    private static final String TAG = "AuthenticationDomain";
    private static final String DIGEST_SHA_512 = "SHA-512";
    private static final String SCHEME_ANDROID = "android";
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private final String mUriStr;
    private final ThreadLocal<Uri> mParsedUri = new ThreadLocal();

    @NonNull
    public static AuthenticationDomain getSelfAuthDomain(@NonNull Context context) {
        Validation.validate((Object)context, (Matcher)CoreMatchers.notNullValue(), IllegalArgumentException.class);
        String packageName = context.getPackageName();
        AuthenticationDomain authenticationDomain = AuthenticationDomain.fromPackageName(context, packageName);
        if (null == authenticationDomain) {
            throw new IllegalStateException("Unable to find package info for " + packageName);
        }
        return authenticationDomain;
    }

    @Nullable
    public static AuthenticationDomain fromPackageName(@NonNull Context context, @NonNull String packageName) {
        PackageInfo packageInfo;
        Validation.validate((Object)context, (Matcher)CoreMatchers.notNullValue(), IllegalArgumentException.class);
        Validation.validate((Object)packageName, CustomMatchers.notNullOrEmptyString(), IllegalArgumentException.class);
        PackageManager pm = context.getPackageManager();
        try {
            packageInfo = pm.getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException ex) {
            return null;
        }
        if (1 != packageInfo.signatures.length) {
            Log.w((String)TAG, (String)String.format("application (%s) did not have exactly one signature", packageName));
            return null;
        }
        return AuthenticationDomain.createAndroidAuthDomain(packageName, packageInfo.signatures[0]);
    }

    @NonNull
    static AuthenticationDomain createAndroidAuthDomain(@NonNull String packageName, @NonNull Signature signature) {
        Validation.validate((Object)packageName, CustomMatchers.notNullOrEmptyString(), IllegalArgumentException.class);
        Validation.validate((Object)signature, (Matcher)CoreMatchers.notNullValue(), IllegalArgumentException.class);
        return new AuthenticationDomain(new Uri.Builder().scheme(SCHEME_ANDROID).encodedAuthority(AuthenticationDomain.generateSignatureHash(signature) + "@" + packageName).build().toString());
    }

    @NonNull
    public static AuthenticationDomain fromProtobufBytes(@NonNull byte[] protobufBytes) throws MalformedDataException {
        Validation.validate((Object)protobufBytes, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
        try {
            return AuthenticationDomain.fromProtobuf(Protobufs.AuthenticationDomain.parseFrom(protobufBytes));
        }
        catch (IOException ex) {
            throw new MalformedDataException("Unable to parse the given protocol buffer", ex);
        }
    }

    @NonNull
    public static AuthenticationDomain fromProtobuf(@NonNull Protobufs.AuthenticationDomain authDomain) throws MalformedDataException {
        Validation.validate((Object)authDomain, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
        try {
            return new AuthenticationDomain(authDomain.getUri());
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedDataException(ex);
        }
    }

    @NonNull
    static String generateSignatureHash(@NonNull Signature signature) {
        try {
            MessageDigest digest = MessageDigest.getInstance(DIGEST_SHA_512);
            byte[] hashBytes = digest.digest(signature.toByteArray());
            return Base64.encodeToString((byte[])hashBytes, (int)8).replace("\n", "");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Platform does not supportSHA-512 hashing");
        }
    }

    public AuthenticationDomain(@NonNull String authDomainString) {
        this.mUriStr = (String)Validation.validate((Object)authDomainString, CustomMatchers.isValidAuthenticationDomain(), IllegalArgumentException.class);
    }

    public boolean isAndroidAuthDomain() {
        return SCHEME_ANDROID.equals(this.getParsedUri().getScheme());
    }

    public boolean isWebAuthDomain() {
        Uri parsedUri = this.getParsedUri();
        return SCHEME_HTTP.equals(parsedUri.getScheme()) || SCHEME_HTTPS.equals(parsedUri.getScheme());
    }

    @NonNull
    public String getAndroidPackageName() {
        if (!this.isAndroidAuthDomain()) {
            throw new IllegalStateException("Authentication domain is not an Android domain");
        }
        return this.getParsedUri().getHost();
    }

    public Protobufs.AuthenticationDomain toProtobuf() {
        return (Protobufs.AuthenticationDomain)Protobufs.AuthenticationDomain.newBuilder().setUri(this.mUriStr).build();
    }

    @NonNull
    public String toString() {
        return this.mUriStr;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AuthenticationDomain)) {
            return false;
        }
        return this.compareTo((AuthenticationDomain)obj) == 0;
    }

    public int hashCode() {
        return this.mUriStr.hashCode();
    }

    @Override
    public int compareTo(@NonNull AuthenticationDomain authenticationDomain) {
        return this.mUriStr.compareTo(authenticationDomain.mUriStr);
    }

    private Uri getParsedUri() {
        Uri parsedUri = this.mParsedUri.get();
        if (parsedUri == null) {
            parsedUri = Uri.parse((String)this.mUriStr);
            this.mParsedUri.set(parsedUri);
        }
        return parsedUri;
    }
}

