/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol.internal;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.protobuf.ByteString;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.valid4j.Assertive;

public final class IntentUtil {
    private IntentUtil() {
        throw new IllegalStateException("not intended to be constructed");
    }

    @NonNull
    public static byte[] toBytes(@NonNull Intent intent) {
        Assertive.require((Object)intent, (Matcher)CoreMatchers.notNullValue());
        Parcel parcel = Parcel.obtain();
        parcel.writeParcelable((Parcelable)intent, 0);
        byte[] intentBytes = parcel.marshall();
        parcel.recycle();
        return intentBytes;
    }

    public static ByteString toByteString(@NonNull Intent intent) {
        Assertive.require((Object)intent, (Matcher)CoreMatchers.notNullValue());
        return ByteString.copyFrom((byte[])IntentUtil.toBytes(intent));
    }

    @NonNull
    public static Intent fromBytes(@NonNull byte[] intentBytes) {
        Assertive.require((Object)intentBytes, (Matcher)CoreMatchers.notNullValue());
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(intentBytes, 0, intentBytes.length);
        parcel.setDataPosition(0);
        Intent intent = (Intent)parcel.readParcelable(IntentUtil.class.getClassLoader());
        parcel.recycle();
        Assertive.ensure((Object)intent, (Matcher)CoreMatchers.notNullValue());
        return intent;
    }
}

