/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol.internal;

import android.net.Uri;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public final class CustomMatchers {
    public static Matcher<Uri> isWebUri() {
        return UriMatcher.WEB_MATCHER;
    }

    public static Matcher<Uri> isHttpsUri() {
        return UriMatcher.HTTPS_ONLY_MATCHER;
    }

    public static Matcher<String> isHttpsUriStr() {
        return StringUriMatcher.HTTPS_URI_STR;
    }

    public static Matcher<String> isValidAuthenticationMethod() {
        return StringUriMatcher.AUTHENTICATION_METHOD_STR;
    }

    public static Matcher<Uri> isValidAuthenticationMethodUri() {
        return UriMatcher.AUTHENTICATION_METHOD;
    }

    public static Matcher<String> isValidAuthenticationDomain() {
        return StringUriMatcher.AUTHENTICATION_DOMAIN_STR;
    }

    public static Matcher<Uri> isValidAuthenticationDomainUri() {
        return UriMatcher.AUTHENTICATION_DOMAIN;
    }

    public static <T> Matcher<T> nullOr(Matcher<T> matcher) {
        return new NullOrOtherMatcher<T>(matcher);
    }

    public static Matcher<String> notNullOrEmptyString() {
        return NotNullOrEmptyStringMatcher.INSTANCE;
    }

    private static final class UriMatcher
    extends CustomTypeSafeMatcher<Uri> {
        static final String SCHEME_HTTP = "http";
        static final String SCHEME_HTTPS = "https";
        static final UriMatcher AUTHENTICATION_DOMAIN = new UriMatcher(Collections.emptySet(), false, "an authentication domain");
        static final UriMatcher AUTHENTICATION_METHOD = new UriMatcher(Collections.emptySet(), false, "an authentication method");
        static final UriMatcher HTTPS_ONLY_MATCHER = new UriMatcher(Collections.singleton("https"), true, "an https URL");
        static final UriMatcher WEB_MATCHER = new UriMatcher(new HashSet<String>(Arrays.asList("http", "https")), true, "a web URL");
        final Set<String> mPermittedSchemes;
        final boolean mAllowPathQueryOrFragment;
        final String mUriDescriptor;

        UriMatcher(Set<String> permittedSchemes, boolean allowPathQueryOrFragment, String uriDescriptor) {
            super(uriDescriptor);
            this.mPermittedSchemes = permittedSchemes;
            this.mAllowPathQueryOrFragment = allowPathQueryOrFragment;
            this.mUriDescriptor = uriDescriptor;
        }

        protected boolean matchesSafely(Uri item) {
            if (!item.isAbsolute() || !item.isHierarchical() || TextUtils.isEmpty((CharSequence)item.getScheme()) || TextUtils.isEmpty((CharSequence)item.getAuthority())) {
                return false;
            }
            if (!this.mPermittedSchemes.isEmpty() && !this.mPermittedSchemes.contains(item.getScheme())) {
                return false;
            }
            if (this.mAllowPathQueryOrFragment) {
                return true;
            }
            return TextUtils.isEmpty((CharSequence)item.getPath()) && item.getQuery() == null && item.getFragment() == null;
        }
    }

    private static final class StringUriMatcher
    extends CustomTypeSafeMatcher<String> {
        static final StringUriMatcher HTTPS_URI_STR = new StringUriMatcher(UriMatcher.HTTPS_ONLY_MATCHER);
        static final StringUriMatcher AUTHENTICATION_DOMAIN_STR = new StringUriMatcher(UriMatcher.AUTHENTICATION_DOMAIN);
        static final StringUriMatcher AUTHENTICATION_METHOD_STR = new StringUriMatcher(UriMatcher.AUTHENTICATION_METHOD);
        private final UriMatcher mUriMatcher;

        StringUriMatcher(UriMatcher matcher) {
            super(matcher.mUriDescriptor);
            this.mUriMatcher = matcher;
        }

        protected boolean matchesSafely(String item) {
            Uri uri = Uri.parse((String)item);
            return this.mUriMatcher.matchesSafely(uri);
        }
    }

    private static final class NullOrOtherMatcher<T>
    extends BaseMatcher<T> {
        final Matcher<T> mMatcher;

        NullOrOtherMatcher(Matcher<T> matcher) {
            this.mMatcher = matcher;
        }

        public boolean matches(Object item) {
            return item == null || this.mMatcher.matches(item);
        }

        public void describeTo(Description description) {
            description.appendText("null or ").appendDescriptionOf(this.mMatcher);
        }
    }

    private static final class NotNullOrEmptyStringMatcher
    extends BaseMatcher<String> {
        private static final NotNullOrEmptyStringMatcher INSTANCE = new NotNullOrEmptyStringMatcher();

        private NotNullOrEmptyStringMatcher() {
        }

        public boolean matches(Object item) {
            if (item == null) {
                return false;
            }
            if (!(item instanceof String)) {
                return false;
            }
            return !TextUtils.isEmpty((CharSequence)((String)item));
        }

        public void describeTo(Description description) {
            description.appendText("is not a null or empty string");
        }
    }
}

