/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol.internal;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import org.openyolo.protocol.Protobufs;

public final class ClientVersionUtil {
    private static final String VENDOR = "openid.net";
    @NonNull
    private static final Protobufs.ClientVersion BUILD_CLIENT_VERSION = (Protobufs.ClientVersion)Protobufs.ClientVersion.newBuilder().setVendor("openid.net").setMajor(ClientVersionUtil.parseVersionPart("0")).setMinor(ClientVersionUtil.parseVersionPart("1")).setPatch(ClientVersionUtil.parseVersionPart("1")).build();
    private static Protobufs.ClientVersion sClientVersion;

    @NonNull
    public static Protobufs.ClientVersion getClientVersion() {
        Protobufs.ClientVersion clientVersion = sClientVersion;
        if (clientVersion == null) {
            sClientVersion = clientVersion = BUILD_CLIENT_VERSION;
        }
        return clientVersion;
    }

    @VisibleForTesting
    public static void setClientVersion(Protobufs.ClientVersion clientVersion) {
        sClientVersion = clientVersion;
    }

    @VisibleForTesting
    static int parseVersionPart(String versionPart) {
        int versionNum;
        if (versionPart == null || versionPart.isEmpty()) {
            return 0;
        }
        try {
            versionNum = Integer.parseInt(versionPart);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
        if (versionNum < 0) {
            return 0;
        }
        return versionNum;
    }
}

