/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol.internal;

import com.google.protobuf.ByteString;
import org.openyolo.protocol.internal.ValueConverter;

public final class ByteStringConverters {
    public static final ValueConverter<ByteString, byte[]> BYTE_STRING_TO_BYTE_ARRAY = new ByteStringToByteArrayConverter();
    public static final ValueConverter<byte[], ByteString> BYTE_ARRAY_TO_BYTE_STRING = new ByteArrayToByteStringConverter();

    private static final class ByteArrayToByteStringConverter
    implements ValueConverter<byte[], ByteString> {
        private ByteArrayToByteStringConverter() {
        }

        @Override
        public ByteString convert(byte[] value) {
            return ByteString.copyFrom((byte[])value);
        }
    }

    private static final class ByteStringToByteArrayConverter
    implements ValueConverter<ByteString, byte[]> {
        private ByteStringToByteArrayConverter() {
        }

        @Override
        public byte[] convert(ByteString value) {
            return value.toByteArray();
        }
    }
}

