/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol.internal;

import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openyolo.protocol.internal.ByteStringConverters;
import org.openyolo.protocol.internal.CollectionConverter;
import org.openyolo.protocol.internal.CustomMatchers;
import org.valid4j.Validation;

public final class AdditionalPropertiesUtil {
    public static Map<String, ByteString> validateAdditionalProperties(@Nullable Map<String, byte[]> additionalProps) {
        if (additionalProps == null) {
            return new HashMap<String, ByteString>();
        }
        Validation.validate(additionalProps.keySet(), (Matcher)CoreMatchers.everyItem(CustomMatchers.notNullOrEmptyString()), IllegalArgumentException.class);
        Validation.validate(additionalProps.values(), (Matcher)CoreMatchers.everyItem((Matcher)CoreMatchers.notNullValue()), IllegalArgumentException.class);
        return CollectionConverter.convertMapValues(additionalProps, ByteStringConverters.BYTE_ARRAY_TO_BYTE_STRING);
    }

    public static Map<String, ByteString> validateAdditionalPropertiesFromProto(@Nullable Map<String, ByteString> additionalProps) {
        if (additionalProps == null) {
            return new HashMap<String, ByteString>();
        }
        Validation.validate(additionalProps.keySet(), (Matcher)CoreMatchers.everyItem(CustomMatchers.notNullOrEmptyString()), IllegalArgumentException.class);
        Validation.validate(additionalProps.values(), (Matcher)CoreMatchers.everyItem((Matcher)CoreMatchers.notNullValue()), IllegalArgumentException.class);
        return additionalProps;
    }

    private AdditionalPropertiesUtil() {
        throw new IllegalStateException("not intended to be constructed");
    }
}

