/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.internal.ByteStringConverters;
import org.openyolo.protocol.internal.CollectionConverter;
import org.openyolo.protocol.internal.IntentUtil;
import org.valid4j.Assertive;

public class RetrieveBbqResponse
implements Parcelable {
    public static final Parcelable.Creator<RetrieveBbqResponse> CREATOR = new RetrieveResultCreator();
    @Nullable
    private final Intent mRetrieveIntent;
    @NonNull
    private final Map<String, Protobufs.CredentialRetrieveBbqResponse> mResponses;

    private RetrieveBbqResponse(@Nullable Intent retrieveIntent, @NonNull Map<String, Protobufs.CredentialRetrieveBbqResponse> responses) {
        this.mRetrieveIntent = retrieveIntent;
        this.mResponses = responses;
    }

    @Nullable
    public Intent getRetrieveIntent() {
        return this.mRetrieveIntent;
    }

    @NonNull
    public Set<String> getResponderPackageNames() {
        return this.mResponses.keySet();
    }

    @NonNull
    public Intent getRetrieveIntentForResponder(@NonNull String responderPackageName) {
        Assertive.require((Object)responderPackageName, (Matcher)CoreMatchers.notNullValue());
        Protobufs.CredentialRetrieveBbqResponse response = this.mResponses.get(responderPackageName);
        if (response == null) {
            throw new IllegalArgumentException(responderPackageName + " is not a responder");
        }
        return IntentUtil.fromBytes(response.getRetrieveIntent().toByteArray());
    }

    @NonNull
    public Map<String, byte[]> getAdditionalPropsForResponder(String responderPackageName) {
        Protobufs.CredentialRetrieveBbqResponse response = this.mResponses.get(responderPackageName);
        if (response == null) {
            throw new IllegalArgumentException(responderPackageName + " is not a responder");
        }
        return CollectionConverter.convertMapValues(response.getAdditionalPropsMap(), ByteStringConverters.BYTE_STRING_TO_BYTE_ARRAY);
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mRetrieveIntent, 0);
        dest.writeInt(this.mResponses.size());
        for (String key : this.mResponses.keySet()) {
            byte[] responseBytes = this.mResponses.get(key).toByteArray();
            dest.writeString(key);
            dest.writeInt(responseBytes.length);
            dest.writeByteArray(responseBytes);
        }
    }

    public int describeContents() {
        return 0;
    }

    static final class RetrieveResultCreator
    implements Parcelable.Creator<RetrieveBbqResponse> {
        RetrieveResultCreator() {
        }

        public RetrieveBbqResponse createFromParcel(Parcel in) {
            Intent retrieveIntent = (Intent)in.readParcelable(Intent.class.getClassLoader());
            int numResponses = in.readInt();
            HashMap<String, Protobufs.CredentialRetrieveBbqResponse> responses = new HashMap<String, Protobufs.CredentialRetrieveBbqResponse>(numResponses);
            for (int i = 0; i < numResponses; ++i) {
                Protobufs.CredentialRetrieveBbqResponse response;
                String key = in.readString();
                int responseSize = in.readInt();
                byte[] responseBytes = new byte[responseSize];
                in.readByteArray(responseBytes);
                try {
                    response = Protobufs.CredentialRetrieveBbqResponse.parseFrom(responseBytes);
                }
                catch (InvalidProtocolBufferException ex) {
                    throw new IllegalArgumentException("Unable to parse response proto");
                }
                responses.put(key, response);
            }
            return new Builder().setRetrieveIntent(retrieveIntent).setProtoResponses(responses).build();
        }

        public RetrieveBbqResponse[] newArray(int size) {
            return new RetrieveBbqResponse[size];
        }
    }

    public static final class Builder {
        @Nullable
        private Intent mIntent = null;
        @NonNull
        private Map<String, Protobufs.CredentialRetrieveBbqResponse> mProtoResponses = Collections.emptyMap();

        @NonNull
        public Builder setProtoResponses(@NonNull Map<String, Protobufs.CredentialRetrieveBbqResponse> protoResponses) {
            Assertive.require(protoResponses, (Matcher)CoreMatchers.notNullValue());
            for (Protobufs.CredentialRetrieveBbqResponse value : protoResponses.values()) {
                Assertive.require((Object)value, (Matcher)CoreMatchers.notNullValue());
            }
            this.mProtoResponses = protoResponses;
            return this;
        }

        @NonNull
        public Builder setRetrieveIntent(@Nullable Intent intent) {
            this.mIntent = intent;
            return this;
        }

        @NonNull
        public RetrieveBbqResponse build() {
            return new RetrieveBbqResponse(this.mIntent, this.mProtoResponses);
        }
    }
}

