/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.Protobufs;
import org.valid4j.Assertive;
import org.valid4j.Validation;

public final class PasswordSpecification
implements Parcelable {
    public static final Parcelable.Creator<PasswordSpecification> CREATOR = new PasswordSpecificationCreator();
    public static final String LOWER_ALPHA = "abcdefghijklmnopqrstuvwxyz";
    public static final String LOWER_ALPHA_DISTINGUISHABLE = "abcdefghijkmnopqrstxyz";
    public static final String UPPER_ALPHA = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String UPPER_ALPHA_DISTINGUISHABLE = "ABCDEFGHJKLMNPQRSTXY";
    public static final String NUMERALS = "1234567890";
    public static final String NUMERALS_DISTINGUISHABLE = "3456789";
    public static final String ALPHANUMERIC = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    public static final String SYMBOLS = " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
    public static final String ALL_PRINTABLE = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890 !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
    public static final String ALPHANUMERIC_DISTINGUISHABLE = "abcdefghijkmnopqrstxyzABCDEFGHJKLMNPQRSTXY3456789";
    public static final int DEFAULT_MIN_PASSWORD_LENGTH = 12;
    public static final int DEFAULT_MAX_PASSWORD_LENGTH = 16;
    public static final int PASSWORD_CONFORMS = 0;
    public static final int PASSWORD_LENGTH_MISMATCH = 1;
    public static final int PASSWORD_REQUIRED_CHARACTER_MISSING = 2;
    public static final int PASSWORD_DISALLOWED_CHARACTER = 4;
    public static final PasswordSpecification DEFAULT = new Builder().ofLength(12, 16).allow("abcdefghijkmnopqrstxyzABCDEFGHJKLMNPQRSTXY3456789").require("abcdefghijkmnopqrstxyz", 1).require("ABCDEFGHJKLMNPQRSTXY", 1).require("3456789", 1).build();
    public static final PasswordSpecification DEFAULT_FOR_VALIDATION = new Builder().ofLength(12, 16).allow("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890").require("abcdefghijklmnopqrstuvwxyz", 1).require("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1).require("1234567890", 1).build();
    private static final int ASCII_PRINTABLE_RANGE_LOWER = 32;
    private static final int ASCII_PRINTABLE_RANGE_UPPER = 126;
    public final String allowedChars;
    public final SortedSet<RequiredCharSet> requiredCharSets;
    public final int minimumSize;
    public final int maximumSize;
    private Integer mHash;
    private Random mRandom;
    private int[] mRequiredSpecMapping;
    private int[] mRequiredCharCounts;

    public static boolean checkResultForError(int result, int mask) {
        return (result & mask) != 0;
    }

    private PasswordSpecification(String allowedChars, SortedSet<RequiredCharSet> requiredCharSets, int minimumSize, int maximumSize) {
        this.allowedChars = allowedChars;
        this.requiredCharSets = Collections.unmodifiableSortedSet(requiredCharSets);
        this.minimumSize = minimumSize;
        this.maximumSize = maximumSize;
    }

    public int checkConformance(String password) {
        int result = 0;
        if (TextUtils.isEmpty((CharSequence)password)) {
            result |= 1;
        }
        if (PasswordSpecification.isOutsideRange(password.length(), this.minimumSize, this.maximumSize)) {
            result |= 1;
        }
        int[] requiredSpecMapping = this.getRequiredSpecMapping();
        int[] requiredSpecRemainingCounts = this.extractRequiredCharCounts();
        for (char c : password.toCharArray()) {
            int requiredSpecIndex;
            if (!this.containsCharacter(this.allowedChars, c)) {
                result |= 4;
            }
            if ((requiredSpecIndex = requiredSpecMapping[PasswordSpecification.getCharMappingIndex(c)]) < 0) continue;
            int n = requiredSpecIndex;
            requiredSpecRemainingCounts[n] = requiredSpecRemainingCounts[n] - 1;
        }
        for (int remaining : requiredSpecRemainingCounts) {
            if (remaining <= 0) continue;
            result |= 2;
            break;
        }
        return result;
    }

    @NonNull
    public String generate() {
        int size = this.minimumSize + this.getRandom().nextInt(this.maximumSize - this.minimumSize + 1);
        ArrayList<Character> chars = new ArrayList<Character>(size);
        for (RequiredCharSet set : this.requiredCharSets) {
            this.selectCharacters(set.chars, set.count, chars);
        }
        int remaining = size - chars.size();
        this.selectCharacters(this.allowedChars, remaining, chars);
        Collections.shuffle(chars);
        return PasswordSpecification.charCollectionToString(chars);
    }

    @NonNull
    public Protobufs.PasswordSpecification toProtocolBuffer() {
        return (Protobufs.PasswordSpecification)Protobufs.PasswordSpecification.newBuilder().setMinSize(this.minimumSize).setMaxSize(this.maximumSize).setAllowed(this.allowedChars).addAllRequiredSets(this.convertRequiredCharSetsToProto()).build();
    }

    public void writeToParcel(Parcel out, int flags) {
        byte[] encoded = this.toProtocolBuffer().toByteArray();
        out.writeInt(encoded.length);
        out.writeByteArray(encoded);
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PasswordSpecification)) {
            return false;
        }
        PasswordSpecification other = (PasswordSpecification)obj;
        if (this.minimumSize != other.minimumSize || this.maximumSize != other.maximumSize || !this.allowedChars.equals(other.allowedChars)) {
            return false;
        }
        if (this.requiredCharSets.size() != other.requiredCharSets.size()) {
            return false;
        }
        Iterator thisRequiredSetIter = this.requiredCharSets.iterator();
        Iterator otherRequiredSetIter = other.requiredCharSets.iterator();
        while (thisRequiredSetIter.hasNext()) {
            if (((RequiredCharSet)thisRequiredSetIter.next()).equals(otherRequiredSetIter.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.mHash != null) {
            return this.mHash;
        }
        int hash = this.minimumSize;
        hash = hash * 92821 + this.maximumSize;
        hash = hash * 92821 + this.allowedChars.hashCode();
        for (RequiredCharSet set : this.requiredCharSets) {
            hash = hash * 92821 + set.chars.hashCode();
            hash = hash * 92821 + set.count;
        }
        this.mHash = hash;
        return this.mHash;
    }

    private List<Protobufs.RequiredCharSet> convertRequiredCharSetsToProto() {
        ArrayList<Protobufs.RequiredCharSet> convertedRequiredCharSets = new ArrayList<Protobufs.RequiredCharSet>();
        for (RequiredCharSet set : this.requiredCharSets) {
            convertedRequiredCharSets.add((Protobufs.RequiredCharSet)Protobufs.RequiredCharSet.newBuilder().setChars(set.chars).setCount(set.count).build());
        }
        return convertedRequiredCharSets;
    }

    private int[] getRequiredSpecMapping() {
        if (this.mRequiredSpecMapping != null) {
            return this.mRequiredSpecMapping;
        }
        int[] requiredSpecMapping = new int[95];
        Arrays.fill(requiredSpecMapping, -1);
        int specIndex = 0;
        for (RequiredCharSet set : this.requiredCharSets) {
            for (char c : set.chars.toCharArray()) {
                requiredSpecMapping[PasswordSpecification.getCharMappingIndex((char)c)] = specIndex;
            }
            ++specIndex;
        }
        this.mRequiredSpecMapping = requiredSpecMapping;
        return this.mRequiredSpecMapping;
    }

    private static int getCharMappingIndex(char ch) {
        return ch - 32;
    }

    private void selectCharacters(String chars, int count, ArrayList<Character> result) {
        Random random = this.getRandom();
        for (int i = 0; i < count; ++i) {
            result.add(Character.valueOf(chars.charAt(random.nextInt(chars.length()))));
        }
    }

    private boolean containsCharacter(String chars, char ch) {
        int pos = Arrays.binarySearch(chars.toCharArray(), ch);
        return pos >= 0 && pos < chars.length() && chars.charAt(pos) == ch;
    }

    private int[] extractRequiredCharCounts() {
        if (this.mRequiredCharCounts == null) {
            this.mRequiredCharCounts = new int[this.requiredCharSets.size()];
            int index = 0;
            for (RequiredCharSet set : this.requiredCharSets) {
                this.mRequiredCharCounts[index] = set.count;
                ++index;
            }
        }
        int[] requiredCharCounts = new int[this.mRequiredCharCounts.length];
        System.arraycopy(this.mRequiredCharCounts, 0, requiredCharCounts, 0, this.mRequiredCharCounts.length);
        return requiredCharCounts;
    }

    private Random getRandom() {
        if (this.mRandom != null) {
            return this.mRandom;
        }
        this.mRandom = new SecureRandom();
        return this.mRandom;
    }

    private static String charCollectionToString(Collection<Character> chars) {
        char[] charArray = new char[chars.size()];
        int pos = 0;
        for (char c : chars) {
            charArray[pos++] = c;
        }
        return new String(charArray);
    }

    private static boolean isOutsideRange(int val, int lowerBound, int upperBound) {
        return val < lowerBound || val > upperBound;
    }

    public static PasswordSpecification fromProtobuf(@NonNull Protobufs.PasswordSpecification protobuf) throws MalformedDataException {
        Validation.validate((Object)protobuf, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
        return new Builder(protobuf).build();
    }

    private static final class PasswordSpecificationCreator
    implements Parcelable.Creator<PasswordSpecification> {
        private PasswordSpecificationCreator() {
        }

        public PasswordSpecification createFromParcel(Parcel parcel) {
            int encodedSize = parcel.readInt();
            byte[] encoded = new byte[encodedSize];
            parcel.readByteArray(encoded);
            try {
                Protobufs.PasswordSpecification proto = Protobufs.PasswordSpecification.parseFrom(encoded);
                return PasswordSpecification.fromProtobuf(proto);
            }
            catch (IOException | MalformedDataException ex) {
                throw new IllegalStateException("Unable to read proto from parcel", ex);
            }
        }

        public PasswordSpecification[] newArray(int size) {
            return new PasswordSpecification[size];
        }
    }

    private static final class RequiredCharSet
    implements Comparable<RequiredCharSet> {
        public final String chars;
        public final int count;

        private RequiredCharSet(String chars, int count) {
            this.chars = chars;
            this.count = count;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof RequiredCharSet)) {
                return false;
            }
            RequiredCharSet other = (RequiredCharSet)obj;
            return this.chars.equals(other.chars) && this.count == other.count;
        }

        public int hashCode() {
            return this.count * 92821 + this.chars.hashCode();
        }

        @Override
        public int compareTo(@NonNull RequiredCharSet other) {
            Assertive.require((Object)other, (Matcher)CoreMatchers.notNullValue());
            if (this.count < other.count) {
                return -1;
            }
            if (this.count > other.count) {
                return 1;
            }
            return this.chars.compareTo(other.chars);
        }
    }

    public static class InvalidSpecificationError
    extends Error {
        public InvalidSpecificationError(String reason) {
            super(reason);
        }
    }

    public static class Builder {
        private final TreeSet<Character> mAllowedCharSet = new TreeSet();
        private final TreeSet<RequiredCharSet> mRequiredCharSets = new TreeSet();
        private int mMinimumSize = -1;
        private int mMaximumSize = -1;

        private Builder(Protobufs.PasswordSpecification proto) throws MalformedDataException {
            try {
                this.ofLength(proto.getMinSize(), proto.getMaxSize());
                this.allow(proto.getAllowed());
                for (Protobufs.RequiredCharSet set : proto.getRequiredSetsList()) {
                    this.require(set.getChars(), set.getCount());
                }
            }
            catch (InvalidSpecificationError er) {
                throw new MalformedDataException(er);
            }
        }

        public Builder() {
        }

        public Builder allow(@NonNull String allowedChars) {
            this.mAllowedCharSet.addAll(this.checkAndSortChars(allowedChars, "allowedChars"));
            return this;
        }

        public Builder require(@NonNull String requiredChars, int count) {
            if (count < 1) {
                throw new InvalidSpecificationError("count must be at least 1");
            }
            TreeSet<Character> requiredCharSet = this.checkAndSortChars(requiredChars, "requiredChars");
            this.mAllowedCharSet.addAll(requiredCharSet);
            this.mRequiredCharSets.add(new RequiredCharSet(PasswordSpecification.charCollectionToString(requiredCharSet), count));
            return this;
        }

        public Builder ofLength(int minimumSize, int maximumSize) {
            if (minimumSize < 1) {
                throw new InvalidSpecificationError("minimumSize must be at least 1");
            }
            if (minimumSize > maximumSize) {
                throw new InvalidSpecificationError("maximumSize must be greater than or equal to minimumSize");
            }
            this.mMinimumSize = minimumSize;
            this.mMaximumSize = maximumSize;
            return this;
        }

        public PasswordSpecification build() {
            if (this.mAllowedCharSet.isEmpty()) {
                throw new InvalidSpecificationError("no allowed characters specified");
            }
            if (this.mMinimumSize < 0) {
                throw new InvalidSpecificationError("minimum and maximum size of password not specified");
            }
            this.checkRequiredCharsTotalCount();
            this.checkRequiredCharsDisjoint();
            return new PasswordSpecification(PasswordSpecification.charCollectionToString(this.mAllowedCharSet), this.mRequiredCharSets, this.mMinimumSize, this.mMaximumSize);
        }

        private TreeSet<Character> checkAndSortChars(String chars, String paramName) {
            if (TextUtils.isEmpty((CharSequence)chars)) {
                throw new InvalidSpecificationError(paramName + " cannot be null or empty");
            }
            TreeSet<Character> filteredChars = new TreeSet<Character>();
            for (char c : chars.toCharArray()) {
                if (PasswordSpecification.isOutsideRange(c, 32, 126)) {
                    throw new InvalidSpecificationError(paramName + " must only contain ASCII printable characters");
                }
                filteredChars.add(Character.valueOf(c));
            }
            return filteredChars;
        }

        private void checkRequiredCharsTotalCount() {
            int count = 0;
            for (RequiredCharSet set : this.mRequiredCharSets) {
                count += set.count;
            }
            if (count > this.mMaximumSize) {
                throw new InvalidSpecificationError("required character count cannot be greater than the max password size");
            }
        }

        private void checkRequiredCharsDisjoint() {
            boolean[] charsUsed = new boolean[95];
            for (RequiredCharSet set : this.mRequiredCharSets) {
                for (char c : set.chars.toCharArray()) {
                    if (charsUsed[c - 32]) {
                        throw new InvalidSpecificationError("character " + c + " occurs in more than one required character set");
                    }
                    charsUsed[c - 32] = true;
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConformanceError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConformanceMask {
    }
}

