/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.support.annotation.NonNull;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.internal.CustomMatchers;
import org.valid4j.Validation;

public final class AuthenticationMethod
implements Comparable<AuthenticationMethod> {
    private final String mUri;

    public static AuthenticationMethod fromProtobufBytes(@NonNull byte[] protoBufBytes) throws MalformedDataException {
        Validation.validate((Object)protoBufBytes, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
        try {
            return AuthenticationMethod.fromProtobuf(Protobufs.AuthenticationMethod.parseFrom(protoBufBytes));
        }
        catch (IOException ex) {
            throw new MalformedDataException(ex);
        }
    }

    public static AuthenticationMethod fromProtobuf(@NonNull Protobufs.AuthenticationMethod authMethod) throws MalformedDataException {
        Validation.validate((Object)authMethod, (Matcher)CoreMatchers.notNullValue(), MalformedDataException.class);
        try {
            return new AuthenticationMethod(authMethod.getUri());
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedDataException(ex);
        }
    }

    public AuthenticationMethod(@NonNull String authMethodUriStr) {
        this.mUri = (String)Validation.validate((Object)authMethodUriStr, CustomMatchers.isValidAuthenticationMethod(), IllegalArgumentException.class);
    }

    public Protobufs.AuthenticationMethod toProtobuf() {
        return (Protobufs.AuthenticationMethod)Protobufs.AuthenticationMethod.newBuilder().setUri(this.mUri).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AuthenticationMethod)) {
            return false;
        }
        return this.compareTo((AuthenticationMethod)obj) == 0;
    }

    public int hashCode() {
        return this.mUri.hashCode();
    }

    @Override
    public int compareTo(@NonNull AuthenticationMethod authMethod) {
        return this.mUri.compareTo(authMethod.mUri);
    }

    public String toString() {
        return this.mUri;
    }
}

