/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.internal.AdditionalPropertiesUtil;
import org.openyolo.protocol.internal.ByteStringConverters;
import org.openyolo.protocol.internal.CollectionConverter;
import org.openyolo.protocol.internal.StringUtil;
import org.valid4j.Validation;

public final class TokenRequestInfo {
    public static final TokenRequestInfo DEFAULT = new Builder().build();
    @Nullable
    private final String mClientId;
    @Nullable
    private final String mNonce;
    @NonNull
    private final Map<String, ByteString> mAdditionalProps;

    public static TokenRequestInfo fromProtobuf(@NonNull Protobufs.TokenRequestInfo proto) throws MalformedDataException {
        Validation.validate((Object)proto, (Matcher)IsNull.notNullValue(), IllegalArgumentException.class);
        return new Builder(proto).build();
    }

    public static TokenRequestInfo fromProtobufBytes(@NonNull byte[] protoBytes) throws MalformedDataException {
        Validation.validate((Object)protoBytes, (Matcher)IsNull.notNullValue(), IllegalArgumentException.class);
        try {
            return TokenRequestInfo.fromProtobuf(Protobufs.TokenRequestInfo.parseFrom(protoBytes));
        }
        catch (IOException ex) {
            throw new MalformedDataException("Unable to parse token request info proto", ex);
        }
    }

    private TokenRequestInfo(Builder builder) {
        this.mClientId = builder.mClientId;
        this.mNonce = builder.mNonce;
        this.mAdditionalProps = Collections.unmodifiableMap(builder.mAdditionalProps);
    }

    @Nullable
    public String getClientId() {
        return this.mClientId;
    }

    @Nullable
    public String getNonce() {
        return this.mNonce;
    }

    public Map<String, byte[]> getAdditionalProperties() {
        return CollectionConverter.convertMapValues(this.mAdditionalProps, ByteStringConverters.BYTE_STRING_TO_BYTE_ARRAY);
    }

    public Protobufs.TokenRequestInfo toProtobuf() {
        Protobufs.TokenRequestInfo.Builder builder = Protobufs.TokenRequestInfo.newBuilder();
        if (this.mClientId != null) {
            builder.setClientId(this.mClientId);
        }
        if (this.mNonce != null) {
            builder.setNonce(this.mNonce);
        }
        builder.putAllAdditionalProps(this.mAdditionalProps);
        return (Protobufs.TokenRequestInfo)builder.build();
    }

    public static final class Builder {
        private String mClientId;
        private String mNonce;
        private Map<String, ByteString> mAdditionalProps;

        public Builder() {
            this.mAdditionalProps = new HashMap<String, ByteString>();
        }

        private Builder(Protobufs.TokenRequestInfo proto) throws MalformedDataException {
            try {
                this.mClientId = StringUtil.nullifyEmptyString(proto.getClientId());
                this.mNonce = StringUtil.nullifyEmptyString(proto.getNonce());
                this.setAdditionalPropertiesFromProto(proto.getAdditionalPropsMap());
            }
            catch (IllegalArgumentException ex) {
                throw new MalformedDataException(ex);
            }
        }

        public Builder setClientId(@Nullable String clientId) {
            this.mClientId = StringUtil.nullifyEmptyString(clientId);
            return this;
        }

        public Builder setNonce(@Nullable String nonce) {
            this.mNonce = StringUtil.nullifyEmptyString(nonce);
            return this;
        }

        public Builder setAdditionalProperties(@Nullable Map<String, byte[]> additionalProps) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalProperties(additionalProps);
            return this;
        }

        private Builder setAdditionalPropertiesFromProto(@NonNull Map<String, ByteString> additionalProps) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalPropertiesFromProto(additionalProps);
            return this;
        }

        public TokenRequestInfo build() {
            return new TokenRequestInfo(this);
        }
    }
}

