/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.openyolo.protocol.Credential;
import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.internal.AdditionalPropertiesUtil;
import org.openyolo.protocol.internal.ByteStringConverters;
import org.openyolo.protocol.internal.ClientVersionUtil;
import org.openyolo.protocol.internal.CollectionConverter;
import org.valid4j.Validation;

public final class CredentialSaveRequest
implements Parcelable {
    public static final Parcelable.Creator<CredentialSaveRequest> CREATOR = new CredentialSaveRequestCreator();
    @NonNull
    private final Credential mCredential;
    @NonNull
    private final Map<String, ByteString> mAdditionalProperties;

    public static CredentialSaveRequest fromProtoBytes(byte[] protoBytes) throws MalformedDataException {
        Validation.validate((Object)protoBytes, (Matcher)IsNull.notNullValue(), MalformedDataException.class);
        try {
            Protobufs.CredentialSaveRequest request = Protobufs.CredentialSaveRequest.parseFrom(protoBytes);
            return new Builder(request).build();
        }
        catch (IOException ex) {
            throw new MalformedDataException(ex);
        }
    }

    public static CredentialSaveRequest fromProtobuf(Protobufs.CredentialSaveRequest request) throws MalformedDataException {
        Validation.validate((Object)request, (Matcher)IsNull.notNullValue(), MalformedDataException.class);
        return new Builder(request).build();
    }

    public static CredentialSaveRequest fromCredential(Credential credential) {
        return new Builder(credential).build();
    }

    private CredentialSaveRequest(Builder builder) {
        this.mCredential = builder.mCredential;
        this.mAdditionalProperties = Collections.unmodifiableMap(builder.mAdditionalProps);
    }

    @NonNull
    public Credential getCredential() {
        return this.mCredential;
    }

    @NonNull
    public Map<String, byte[]> getAdditionalProperties() {
        return CollectionConverter.convertMapValues(this.mAdditionalProperties, ByteStringConverters.BYTE_STRING_TO_BYTE_ARRAY);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        byte[] protoBytes = this.toProtocolBuffer().toByteArray();
        dest.writeInt(protoBytes.length);
        dest.writeByteArray(protoBytes);
    }

    public Protobufs.CredentialSaveRequest toProtocolBuffer() {
        return (Protobufs.CredentialSaveRequest)Protobufs.CredentialSaveRequest.newBuilder().setClientVersion(ClientVersionUtil.getClientVersion()).setCredential(this.mCredential.toProtobuf()).putAllAdditionalProps(this.mAdditionalProperties).build();
    }

    private static final class CredentialSaveRequestCreator
    implements Parcelable.Creator<CredentialSaveRequest> {
        private CredentialSaveRequestCreator() {
        }

        public CredentialSaveRequest createFromParcel(Parcel source) {
            int length = source.readInt();
            byte[] encodedRequest = new byte[length];
            source.readByteArray(encodedRequest);
            try {
                return CredentialSaveRequest.fromProtoBytes(encodedRequest);
            }
            catch (MalformedDataException ex) {
                throw new IllegalStateException("Unable to read proto from parcel", ex);
            }
        }

        public CredentialSaveRequest[] newArray(int size) {
            return new CredentialSaveRequest[0];
        }
    }

    public static final class Builder {
        private Credential mCredential;
        private Map<String, ByteString> mAdditionalProps = new HashMap<String, ByteString>();

        private Builder(@NonNull Protobufs.CredentialSaveRequest request) throws MalformedDataException {
            Validation.validate((Object)request, (Matcher)IsNull.notNullValue(), MalformedDataException.class);
            try {
                this.setCredential(Credential.fromProtobuf(request.getCredential()));
                this.setAdditionalProperties(CollectionConverter.convertMapValues(request.getAdditionalPropsMap(), ByteStringConverters.BYTE_STRING_TO_BYTE_ARRAY));
            }
            catch (IllegalArgumentException ex) {
                throw new MalformedDataException(ex);
            }
        }

        public Builder(@NonNull Credential credential) {
            this.setCredential(credential);
        }

        public Builder setCredential(@NonNull Credential credential) {
            Validation.validate((Object)credential, (Matcher)IsNull.notNullValue(), IllegalArgumentException.class);
            this.mCredential = credential;
            return this;
        }

        @NonNull
        public Builder setAdditionalProperties(@Nullable Map<String, byte[]> additionalParams) {
            this.mAdditionalProps = AdditionalPropertiesUtil.validateAdditionalProperties(additionalParams);
            return this;
        }

        public CredentialSaveRequest build() {
            return new CredentialSaveRequest(this);
        }
    }
}

