/*
 * Decompiled with CFR 0.152.
 */
package com.google.bbq;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.bbq.Protobufs;
import com.google.bbq.QueryUtil;
import com.google.protobuf.ByteString;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.valid4j.Assertive;
import org.valid4j.Validation;

public class QueryResponseSender {
    private static final String LOG_TAG = "QueryResponseSender";
    private final Context mContext;

    public QueryResponseSender(@NonNull Context context) {
        this.mContext = (Context)Assertive.require((Object)context, (Matcher)CoreMatchers.notNullValue());
    }

    public void sendResponse(@NonNull Protobufs.BroadcastQuery query, @Nullable byte[] responseMessage) {
        Validation.validate((Object)query, (Matcher)CoreMatchers.notNullValue(), NullPointerException.class);
        Protobufs.BroadcastQueryResponse.Builder responseBuilder = this.createResponseBuilder(query);
        if (responseMessage != null) {
            responseBuilder.setResponseMessage(ByteString.copyFrom((byte[])responseMessage));
        }
        Intent responseBroadcast = this.getIntentForQuery(query, responseBuilder);
        this.mContext.sendBroadcast(responseBroadcast);
    }

    @VisibleForTesting
    @NonNull
    Intent getIntentForQuery(@NonNull Protobufs.BroadcastQuery query, Protobufs.BroadcastQueryResponse.Builder responseBuilder) {
        Intent responseBroadcast = new Intent(QueryUtil.createResponseAction(query.getDataType(), query.getRequestId()));
        responseBroadcast.addCategory("com.google.bbq.QUERY");
        responseBroadcast.setPackage(query.getRequestingApp());
        responseBroadcast.putExtra("com.google.bbq.response", ((Protobufs.BroadcastQueryResponse)responseBuilder.build()).toByteArray());
        return responseBroadcast;
    }

    private Protobufs.BroadcastQueryResponse.Builder createResponseBuilder(Protobufs.BroadcastQuery query) {
        return Protobufs.BroadcastQueryResponse.newBuilder().setRequestId(query.getRequestId()).setResponseId(query.getResponseId());
    }
}

