/*
 * Decompiled with CFR 0.152.
 */
package com.google.bbq;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.valid4j.Assertive;

public class QueryResponse
implements Parcelable {
    public static final Parcelable.Creator<QueryResponse> CREATOR = new QueryResponseCreator();
    @NonNull
    public final String responderPackage;
    public final long responseId;
    @Nullable
    public final byte[] responseMessage;

    public QueryResponse(@NonNull String responderPackage, long responseId, @Nullable byte[] responseMessage) {
        Assertive.require((Object)responderPackage, (Matcher)CoreMatchers.notNullValue());
        this.responderPackage = responderPackage;
        this.responseId = responseId;
        this.responseMessage = responseMessage;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.responderPackage);
        dest.writeLong(this.responseId);
        dest.writeInt(this.responseMessage != null ? 1 : 0);
        if (this.responseMessage != null) {
            dest.writeInt(this.responseMessage.length);
            dest.writeByteArray(this.responseMessage);
        }
    }

    private static final class QueryResponseCreator
    implements Parcelable.Creator<QueryResponse> {
        private QueryResponseCreator() {
        }

        public QueryResponse createFromParcel(Parcel source) {
            String responderPackage = source.readString();
            long responseId = source.readLong();
            byte[] responseMessage = null;
            if (source.readInt() != 0) {
                int responseMessageSize = source.readInt();
                responseMessage = new byte[responseMessageSize];
                source.readByteArray(responseMessage);
            }
            return new QueryResponse(responderPackage, responseId, responseMessage);
        }

        public QueryResponse[] newArray(int size) {
            return new QueryResponse[size];
        }
    }
}

