/*
 * Decompiled with CFR 0.152.
 */
package com.google.bbq;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.bbq.Protobufs;
import com.google.bbq.QueryCallback;
import com.google.bbq.QueryResponse;
import com.google.bbq.QueryUtil;
import com.google.bbq.internal.ClientVersionUtil;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.valid4j.Assertive;

public class BroadcastQueryClient {
    public static final long DEFAULT_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(2L);
    private static final String LOG_TAG = "BroadcastQueryClient";
    private static final AtomicReference<BroadcastQueryClient> INSTANCE = new AtomicReference();
    @NonNull
    private final Context mContext;
    @NonNull
    private final SecureRandom mSecureRandom;
    @NonNull
    private final ConcurrentHashMap<Long, PendingQuery> mPendingQueries;
    @NonNull
    private final ScheduledExecutorService mExecutorService;
    @NonNull
    private final AtomicBoolean mDisposed;

    @NonNull
    public static BroadcastQueryClient getInstance(Context context) {
        Context applicationContext = context.getApplicationContext();
        BroadcastQueryClient client = new BroadcastQueryClient(applicationContext);
        if (!INSTANCE.compareAndSet(null, client)) {
            client.dispose();
            client = INSTANCE.get();
        }
        return client;
    }

    BroadcastQueryClient(@NonNull Context context) {
        this.mContext = context;
        this.mSecureRandom = new SecureRandom();
        this.mPendingQueries = new ConcurrentHashMap();
        this.mExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.mDisposed = new AtomicBoolean(false);
    }

    public void queryFor(@NonNull String dataType, @Nullable MessageLite queryMessage, @NonNull QueryCallback callback) {
        this.queryFor(dataType, queryMessage, DEFAULT_TIMEOUT_MS, callback);
    }

    public void queryFor(@NonNull String dataType, @Nullable MessageLite queryMessage, long timeoutInMs, @NonNull QueryCallback callback) {
        this.queryFor(dataType, queryMessage != null ? queryMessage.toByteArray() : null, timeoutInMs, callback);
    }

    public void queryFor(@NonNull String dataType, @Nullable byte[] queryMessage, long timeoutInMs, @NonNull QueryCallback callback) {
        long queryId;
        Assertive.require((!TextUtils.isEmpty((CharSequence)dataType) ? 1 : 0) != 0, (String)"dataType must not be null or empty", (Object[])new Object[0]);
        Assertive.require((timeoutInMs > 0L ? 1 : 0) != 0, (String)"Timeout must be greater than zero", (Object[])new Object[0]);
        Assertive.require((Object)callback, (Matcher)CoreMatchers.notNullValue());
        Assertive.require((!this.isDisposed() ? 1 : 0) != 0, (String)"BroadcastQueryClient has been disposed", (Object[])new Object[0]);
        PendingQuery pq = new PendingQuery(dataType, queryMessage, timeoutInMs, callback);
        while (this.mPendingQueries.putIfAbsent(queryId = this.mSecureRandom.nextLong(), pq) != null) {
        }
        pq.dispatch(queryId);
    }

    private void dispose() {
        if (!this.mDisposed.compareAndSet(false, true)) {
            return;
        }
        this.mExecutorService.shutdownNow();
        for (PendingQuery pq : this.mPendingQueries.values()) {
            this.mContext.unregisterReceiver(pq.mResponseReceiver);
        }
    }

    private boolean isDisposed() {
        return this.mDisposed.get();
    }

    private Intent createQueryIntent(PendingQuery pendingQuery, String responderPackage, long responseId) {
        Intent queryIntent = QueryUtil.createEmptyQueryIntent(pendingQuery.mDataType);
        queryIntent.setPackage(responderPackage);
        queryIntent.putExtra("com.google.bbq.message", ((Protobufs.BroadcastQuery)Protobufs.BroadcastQuery.newBuilder().setClientVersion(ClientVersionUtil.getClientVersion()).setRequestingApp(this.mContext.getPackageName()).setDataType(pendingQuery.mDataType).setRequestId(pendingQuery.mQueryId).setResponseId(responseId).setQueryMessage(pendingQuery.mQueryMessage != null ? ByteString.copyFrom((byte[])pendingQuery.mQueryMessage) : null).build()).toByteArray());
        return queryIntent;
    }

    private final class ResponseHandler
    extends BroadcastReceiver {
        final PendingQuery mPendingQuery;

        ResponseHandler(PendingQuery pendingQuery) {
            this.mPendingQuery = pendingQuery;
        }

        public void onReceive(Context context, Intent intent) {
            Protobufs.BroadcastQueryResponse response;
            byte[] responseBytes = intent.getByteArrayExtra("com.google.bbq.response");
            if (responseBytes == null) {
                Log.w((String)BroadcastQueryClient.LOG_TAG, (String)"Received query response without a defined message");
                return;
            }
            try {
                response = Protobufs.BroadcastQueryResponse.parseFrom(responseBytes);
            }
            catch (IOException e) {
                Log.w((String)BroadcastQueryClient.LOG_TAG, (String)"Unable to parse query response message");
                return;
            }
            String responder = this.mPendingQuery.mRespondersById.get(response.getResponseId());
            if (responder == null) {
                Log.w((String)BroadcastQueryClient.LOG_TAG, (String)"Received response from unknown responder");
                return;
            }
            if (!this.mPendingQuery.mPendingResponses.remove(response.getResponseId())) {
                Log.w((String)BroadcastQueryClient.LOG_TAG, (String)"Duplicate response received; ignoring");
                return;
            }
            if (response.getResponseMessage() != null) {
                QueryResponse queryResponse = new QueryResponse(responder, response.getResponseId(), response.getResponseMessage().toByteArray());
                this.mPendingQuery.mResponses.put(responder, queryResponse);
            }
            if (this.mPendingQuery.mPendingResponses.isEmpty()) {
                this.mPendingQuery.complete();
            }
        }
    }

    private final class QueryTimeoutHandler
    implements Callable<Void> {
        final PendingQuery mPendingQuery;

        QueryTimeoutHandler(PendingQuery pendingQuery) {
            this.mPendingQuery = pendingQuery;
        }

        @Override
        public Void call() throws Exception {
            this.mPendingQuery.complete();
            return null;
        }
    }

    private final class PendingQuery {
        final String mDataType;
        final byte[] mQueryMessage;
        final Map<Long, String> mRespondersById;
        final CopyOnWriteArraySet<Long> mPendingResponses;
        final ConcurrentHashMap<String, QueryResponse> mResponses;
        final QueryCallback mQueryCallback;
        final long mTimeoutInMs;
        long mQueryId;
        ScheduledFuture<Void> mTimeoutFuture;
        BroadcastReceiver mResponseReceiver;

        PendingQuery(String dataType, byte[] queryMessage, long timeoutInMs, QueryCallback queryCallback) {
            this.mDataType = dataType;
            this.mQueryMessage = queryMessage;
            this.mTimeoutInMs = timeoutInMs;
            this.mRespondersById = this.buildRespondersById();
            this.mPendingResponses = new CopyOnWriteArraySet();
            for (long responderId : this.mRespondersById.keySet()) {
                this.mPendingResponses.add(responderId);
            }
            this.mResponses = new ConcurrentHashMap();
            this.mQueryCallback = queryCallback;
        }

        Map<Long, String> buildRespondersById() {
            Set<String> responders = QueryUtil.getRespondersForDataType(BroadcastQueryClient.this.mContext, this.mDataType);
            HashMap<Long, String> tempRespondersById = new HashMap<Long, String>();
            for (String responderPackage : responders) {
                long responderId;
                while (tempRespondersById.containsKey(responderId = BroadcastQueryClient.this.mSecureRandom.nextLong())) {
                }
                tempRespondersById.put(responderId, responderPackage);
            }
            return tempRespondersById;
        }

        void dispatch(long queryId) {
            this.mQueryId = queryId;
            if (this.mRespondersById.isEmpty()) {
                this.complete();
                return;
            }
            this.mResponseReceiver = new ResponseHandler(this);
            BroadcastQueryClient.this.mContext.registerReceiver(this.mResponseReceiver, this.getResponseFilter());
            for (Map.Entry<Long, String> responderEntry : this.mRespondersById.entrySet()) {
                long responseId = responderEntry.getKey();
                String responderPackage = responderEntry.getValue();
                BroadcastQueryClient.this.mContext.sendBroadcast(BroadcastQueryClient.this.createQueryIntent(this, responderPackage, responseId));
            }
            this.mTimeoutFuture = BroadcastQueryClient.this.mExecutorService.schedule(new QueryTimeoutHandler(this), this.mTimeoutInMs, TimeUnit.MILLISECONDS);
        }

        void complete() {
            if (!BroadcastQueryClient.this.mPendingQueries.remove(this.mQueryId, this)) {
                return;
            }
            if (this.mTimeoutFuture != null) {
                this.mTimeoutFuture.cancel(false);
            }
            if (this.mResponseReceiver != null) {
                BroadcastQueryClient.this.mContext.unregisterReceiver(this.mResponseReceiver);
            }
            this.mQueryCallback.onResponse(this.mQueryId, new ArrayList<QueryResponse>(this.mResponses.values()));
        }

        IntentFilter getResponseFilter() {
            IntentFilter filter = new IntentFilter();
            filter.addAction(QueryUtil.createResponseAction(this.mDataType, this.mQueryId));
            filter.addCategory("com.google.bbq.QUERY");
            return filter;
        }
    }
}

