/*
 * Decompiled with CFR 0.152.
 */
package com.google.bbq;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.bbq.Protobufs;
import java.io.IOException;

public abstract class BaseBroadcastQueryReceiver
extends BroadcastReceiver {
    protected final String mLogTag;

    public BaseBroadcastQueryReceiver(String logTag) {
        this.mLogTag = logTag;
    }

    public void onReceive(Context context, Intent intent) {
        Protobufs.BroadcastQuery query;
        byte[] queryBytes = intent.getByteArrayExtra("com.google.bbq.message");
        if (queryBytes == null) {
            Log.w((String)this.mLogTag, (String)"Received message without query data");
            return;
        }
        try {
            query = Protobufs.BroadcastQuery.parseFrom(queryBytes);
        }
        catch (IOException e) {
            Log.w((String)this.mLogTag, (String)"Unable to decode query data");
            return;
        }
        try {
            context.getPackageManager().getPackageInfo(query.getRequestingApp(), 0);
        }
        catch (PackageManager.NameNotFoundException ex) {
            Log.w((String)this.mLogTag, (String)("Received query from non-existent app: " + query.getRequestingApp()));
            return;
        }
        this.processQuery(context, query);
    }

    protected abstract void processQuery(@NonNull Context var1, @NonNull Protobufs.BroadcastQuery var2);
}

