/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.visualizer;

import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.index.strtree.STRtree;
import org.opentripplanner.astar.model.GraphPath;
import org.opentripplanner.astar.model.ShortestPathTree;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.graph_builder.issue.api.DataImportIssue;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.street.StreetVehicleRentalLink;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.ElevatorAlightEdge;
import org.opentripplanner.street.model.edge.ElevatorBoardEdge;
import org.opentripplanner.street.model.edge.FreeEdge;
import org.opentripplanner.street.model.edge.PathwayEdge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.edge.StreetTransitEntityLink;
import org.opentripplanner.street.model.edge.StreetVehicleParkingLink;
import org.opentripplanner.street.model.edge.VehicleParkingEdge;
import org.opentripplanner.street.model.vertex.ElevatorOffboardVertex;
import org.opentripplanner.street.model.vertex.ElevatorOnboardVertex;
import org.opentripplanner.street.model.vertex.ExitVertex;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.SplitterVertex;
import org.opentripplanner.street.model.vertex.StreetLocation;
import org.opentripplanner.street.model.vertex.TemporaryVertex;
import org.opentripplanner.street.model.vertex.TransitBoardingAreaVertex;
import org.opentripplanner.street.model.vertex.TransitEntranceVertex;
import org.opentripplanner.street.model.vertex.TransitPathwayNodeVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.visualizer.VertexSelectionListener;
import processing.core.PApplet;
import processing.core.PFont;

public class ShowGraph
extends PApplet
implements MouseWheelListener {
    private static final int FRAME_RATE = 30;
    private static final boolean VIDEO = false;
    private static final String VIDEO_PATH = "/home/syncopate/pathimage/";
    private static final DecimalFormat latFormatter = new DecimalFormat("00.0000\u00b0N ; 00.0000\u00b0S");
    private static final DecimalFormat lonFormatter = new DecimalFormat("000.0000\u00b0E ; 000.0000\u00b0W");
    static final int DRAW_MINIMAL = 0;
    static final int DRAW_HIGHLIGHTED = 1;
    static final int DRAW_SPT = 2;
    static final int DRAW_VERTICES = 3;
    static final int DRAW_TRANSIT = 4;
    static final int DRAW_LINKS = 5;
    static final int DRAW_STREETS = 6;
    static final int DRAW_ALL = 7;
    static final int DRAW_PARTIAL = 8;
    private static double lastLabelY;
    private final int BLOCK_SIZE = 1000;
    private final long DECIMATE = 40L;
    private final int FRAME_TIME = 26;
    private final ArrayList<VertexSelectionListener> selectors;
    private final List<Edge> visibleStreetEdges = new ArrayList<Edge>(1000);
    private final List<Edge> visibleLinkEdges = new ArrayList<Edge>(1000);
    private final List<Edge> visibleTransitEdges = new ArrayList<Edge>(1000);
    private final Queue<Vertex> newHighlightedVertices = new LinkedBlockingQueue<Vertex>();
    private final Queue<Edge> newHighlightedEdges = new LinkedBlockingQueue<Edge>();
    private static final DateTimeFormatter shortDateFormat;
    private final LinkedBlockingQueue<State> newSPTEdges = new LinkedBlockingQueue();
    private final boolean drawEdges = true;
    private int videoFrameNumber = 0;
    Graph graph;
    STRtree vertexIndex;
    STRtree edgeIndex;
    Envelope modelOuterBounds;
    Envelope modelBounds = new Envelope();
    VertexSelectionListener selector;
    private List<Vertex> visibleVertices;
    private List<Vertex> highlightedVertices = new ArrayList<Vertex>(1000);
    private List<Edge> highlightedEdges = new ArrayList<Edge>(1000);
    private Coordinate highlightedCoordinate;
    private Edge highlightedEdge;
    private GraphPath highlightedGraphPath;
    protected double mouseModelX;
    protected double mouseModelY;
    private Point startDrag = null;
    private int dragX;
    private int dragY;
    private boolean ctrlPressed = false;
    boolean drawFast = false;
    boolean drawStreetEdges = true;
    boolean drawTransitEdges = true;
    boolean drawLinkEdges = true;
    boolean drawStreetVertices = true;
    boolean drawTransitStopVertices = true;
    boolean drawExtraVertices = true;
    private int drawLevel = 7;
    private int drawOffset = 0;
    private boolean drawHighlighted = true;
    public SimpleSPT simpleSPT = new SimpleSPT();
    private LinkedBlockingQueue<SPTNode> sptEdgeQueue;
    private boolean sptVisible = true;
    private float sptFlattening = 0.3f;
    private float sptThickness = 0.1f;
    private boolean drawMultistateVertices = true;
    private ShortestPathTree spt;

    public ShowGraph(VertexSelectionListener selector, Graph graph) {
        this.graph = graph;
        this.spt = null;
        this.selector = selector;
        this.selectors = new ArrayList();
    }

    public void setup() {
        this.size(this.getSize().width, this.getSize().height, "processing.core.PGraphicsJava2D");
        this.buildSpatialIndex();
        this.modelBounds = (Envelope)this.vertexIndex.getRoot().getBounds();
        this.modelBounds.expandBy(0.02);
        this.matchAspect();
        this.modelOuterBounds = new Envelope(this.modelBounds);
        String[] fonts = PFont.list();
        String[] preferredFonts = new String[]{"Mono", "Courier"};
        PFont font = null;
        for (String preferredFontName : preferredFonts) {
            for (String fontName : fonts) {
                if (!fontName.contains(preferredFontName)) continue;
                font = this.createFont(fontName, 16.0f);
                break;
            }
            if (font != null) break;
        }
        this.textFont(font);
        this.textMode(256);
        this.addMouseWheelListener(this);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                Point p = e.getPoint();
                ShowGraph.this.mouseModelX = ShowGraph.this.toModelX(p.x);
                ShowGraph.this.mouseModelY = ShowGraph.this.toModelY(p.y);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ShowGraph.this.matchAspect();
                ShowGraph.this.drawLevel = 8;
            }
        });
        this.frameRate(30.0f);
    }

    public synchronized void draw() {
        this.smooth();
        int startMillis = this.millis();
        if (this.drawLevel == 8) {
            this.drawPartial(startMillis);
        } else if (this.drawLevel == 7) {
            boolean finished = this.drawAll(startMillis);
            if (!finished) {
                return;
            }
        } else if (this.drawLevel == 5) {
            boolean finished = this.drawLinks(startMillis);
            if (!finished) {
                return;
            }
        } else if (this.drawLevel == 4) {
            boolean finished = this.drawTransit(startMillis);
            if (!finished) {
                return;
            }
        } else if (this.drawLevel == 3) {
            this.drawVertices();
        } else if (this.drawLevel == 2) {
            boolean finished = this.drawSPT();
            if (!finished) {
                return;
            }
        } else if (this.drawLevel == 1) {
            this.drawHighlighted();
        } else if (this.drawLevel == 0) {
            if (!this.newHighlightedEdges.isEmpty()) {
                this.handleNewHighlights();
            }
            this.drawNewEdges();
            this.drawCoords();
        }
        this.drawOffset = 0;
        if (this.drawLevel > 0) {
            --this.drawLevel;
        }
    }

    public void redraw() {
        this.drawLevel = 7;
    }

    public void mouseReleased(MouseEvent e) {
        this.startDrag = null;
    }

    public void mouseDragged(MouseEvent e) {
        Point c = e.getPoint();
        if (this.startDrag == null) {
            this.startDrag = c;
            this.dragX = c.x;
            this.dragY = c.y;
        }
        double dx = this.dragX - c.x;
        double dy = c.y - this.dragY;
        if (this.ctrlPressed || this.mouseButton == 39) {
            this.zoom(dy * 0.01, this.startDrag);
        } else {
            double tx = this.modelBounds.getWidth() * dx / (double)this.getWidth();
            double ty = this.modelBounds.getHeight() * dy / (double)this.getHeight();
            this.modelBounds.translate(tx, ty);
        }
        this.dragX = c.x;
        this.dragY = c.y;
        this.drawLevel = 8;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double f = (double)e.getWheelRotation() * 0.2;
        this.zoom(f, e.getPoint());
    }

    public void mouseClicked() {
        Envelope screenEnv = new Envelope(new Coordinate((double)this.mouseX, (double)this.mouseY));
        screenEnv.expandBy(4.0, 4.0);
        Envelope env = new Envelope(this.toModelX(screenEnv.getMinX()), this.toModelX(screenEnv.getMaxX()), this.toModelY(screenEnv.getMinY()), this.toModelY(screenEnv.getMaxY()));
        List nearby = this.vertexIndex.query(env);
        this.selector.verticesSelected(nearby);
        this.drawLevel = 7;
    }

    public void keyPressed() {
        if (this.key == '\uffff' && this.keyCode == 17) {
            this.ctrlPressed = true;
        }
    }

    public void keyReleased() {
        if (this.key == '\uffff' && this.keyCode == 17) {
            this.ctrlPressed = false;
        }
    }

    public void zoomToDefault() {
        this.modelBounds = new Envelope(this.modelOuterBounds);
        this.drawLevel = 7;
    }

    public void zoomOut() {
        this.modelBounds.expandBy(this.modelBounds.getWidth(), this.modelBounds.getHeight());
        this.drawLevel = 7;
    }

    public void zoomToLocation(Coordinate c) {
        Envelope e = new Envelope();
        e.expandToInclude(c);
        e.expandBy(0.002);
        this.modelBounds = e;
        this.matchAspect();
        this.drawLevel = 7;
    }

    public void zoomToVertex(Vertex v) {
        Envelope e = new Envelope();
        e.expandToInclude(v.getCoordinate());
        e.expandBy(0.002);
        this.modelBounds = e;
        this.drawLevel = 7;
    }

    public void zoomToEnvelope(Envelope e) {
        this.modelBounds = e;
        this.matchAspect();
        this.drawLevel = 7;
    }

    public synchronized void buildSpatialIndex() {
        this.vertexIndex = new STRtree();
        this.edgeIndex = new STRtree();
        for (Vertex v : this.graph.getVertices()) {
            Coordinate c = v.getCoordinate();
            Envelope env = new Envelope(c);
            this.vertexIndex.insert(env, (Object)v);
            for (Edge e : v.getOutgoing()) {
                LineString edgeGeometry = e.getGeometry();
                if (edgeGeometry == null) {
                    this.edgeIndex.insert(new Envelope(e.getFromVertex().getCoordinate(), e.getToVertex().getCoordinate()), (Object)e);
                    continue;
                }
                this.edgeIndex.insert(edgeGeometry.getEnvelopeInternal(), (Object)e);
            }
        }
        this.vertexIndex.build();
        this.edgeIndex.build();
    }

    public void pushSelector(VertexSelectionListener newSelector) {
        this.selectors.add(this.selector);
        this.selector = newSelector;
    }

    public void popSelector() {
        this.selector = this.selectors.get(this.selectors.size() - 1);
        this.selectors.remove(this.selectors.size() - 1);
    }

    public void highlightCoordinate(Coordinate c) {
        double xd = 0.0;
        double yd = 0.0;
        while (!this.modelBounds.contains(c)) {
            xd = this.modelBounds.getWidth() / 100.0;
            yd = this.modelBounds.getHeight() / 100.0;
            this.modelBounds.expandBy(xd, yd);
        }
        this.modelBounds.expandBy(xd, yd);
        this.highlightedCoordinate = c;
        this.drawLevel = 7;
    }

    public void highlightVertex(Vertex v) {
        this.highlightCoordinate(v.getCoordinate());
    }

    public void enqueueHighlightedEdge(Edge de) {
        this.newHighlightedEdges.add(de);
    }

    public void clearHighlights() {
        this.highlightedEdges.clear();
        this.highlightedVertices.clear();
        this.drawLevel = 7;
    }

    public void highlightEdge(Edge selected) {
        this.highlightedEdge = selected;
        this.drawLevel = 7;
    }

    public void highlightGraphPath(GraphPath gp) {
        this.highlightedGraphPath = gp;
        this.drawLevel = 4;
    }

    public void setHighlightedVertices(Set<Vertex> vertices) {
        this.highlightedVertices = new ArrayList<Vertex>(vertices);
        this.drawLevel = 7;
    }

    public void setHighlightedVertices(List<Vertex> vertices) {
        this.highlightedVertices = vertices;
        this.drawLevel = 7;
    }

    public void setHighlightedEdges(List<Edge> edges) {
        this.highlightedEdges = edges;
        this.drawLevel = 7;
    }

    public void drawIssue(DataImportIssue anno) {
        Envelope env = new Envelope();
        Edge e = anno.getReferencedEdge();
        if (e != null) {
            this.enqueueHighlightedEdge(e);
            env.expandToInclude(e.getFromVertex().getCoordinate());
            env.expandToInclude(e.getToVertex().getCoordinate());
        }
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        Vertex v = anno.getReferencedVertex();
        if (v != null) {
            env.expandToInclude(v.getCoordinate());
            vertices.add(v);
        }
        if (e == null && v == null) {
            return;
        }
        env.expandBy(0.02);
        this.clearHighlights();
        this.setHighlightedVertices(vertices);
        this.zoomToEnvelope(env);
        this.draw();
    }

    public void setShowTransit(boolean selected) {
        this.drawTransitEdges = selected;
        this.drawTransitStopVertices = selected;
    }

    public void setShowStreets(boolean selected) {
        this.drawStreetEdges = selected;
        this.drawStreetVertices = selected;
    }

    public void setShowHightlights(boolean selected) {
        this.drawHighlighted = selected;
    }

    public void addNewSPTEdge(State state) {
        this.newSPTEdges.add(state);
        this.simpleSPT.add(state);
    }

    public void resetSPT() {
        this.simpleSPT = new SimpleSPT();
    }

    public void setShowSPT(boolean selected) {
        this.sptVisible = selected;
    }

    public void setSPTFlattening(float sptFlattening) {
        this.sptFlattening = sptFlattening;
    }

    public void setSPTThickness(float sptThickness) {
        this.sptThickness = sptThickness;
    }

    public void setShowMultistateVertices(boolean selected) {
        this.drawMultistateVertices = selected;
    }

    public void setSPT(ShortestPathTree spt) {
        this.spt = spt;
    }

    void zoom(double f, Point p) {
        double ex = this.modelBounds.getWidth() * f;
        double ey = this.modelBounds.getHeight() * f;
        this.modelBounds.expandBy(ex / 2.0, ey / 2.0);
        if (p != null) {
            double tx = ex * -(p.getX() / (double)this.width - 0.5);
            double ty = ey * (p.getY() / (double)this.height - 0.5);
            this.modelBounds.translate(tx, ty);
        }
        this.drawLevel = 8;
    }

    void matchAspect() {
        double yCenter = this.modelBounds.centre().y;
        float xScale = ShowGraph.cos((float)ShowGraph.radians((float)((float)yCenter)));
        double newX = this.modelBounds.getHeight() * (double)(1.0f / xScale) * (double)((float)this.getWidth() / (float)this.getHeight());
        this.modelBounds.expandBy((newX - this.modelBounds.getWidth()) / 2.0, 0.0);
    }

    private static LineString getOrCreateGeometry(Edge edge) {
        LineString edgeGeometry = edge.getGeometry();
        if (edgeGeometry != null) {
            return edgeGeometry;
        }
        Coordinate[] coordinates = new Coordinate[]{edge.getFromVertex().getCoordinate(), edge.getToVertex().getCoordinate()};
        return GeometryUtils.getGeometryFactory().createLineString(coordinates);
    }

    private synchronized void findVisibleElements() {
        this.visibleVertices = this.vertexIndex.query(this.modelBounds);
        this.visibleStreetEdges.clear();
        this.visibleLinkEdges.clear();
        this.visibleTransitEdges.clear();
        for (Edge de : this.edgeIndex.query(this.modelBounds)) {
            if (de instanceof PathwayEdge || de instanceof VehicleParkingEdge || de instanceof StreetTransitEntityLink || de instanceof FreeEdge || de instanceof StreetVehicleParkingLink || de instanceof StreetVehicleRentalLink) {
                this.visibleLinkEdges.add(de);
                continue;
            }
            if (!(de instanceof StreetEdge) && !(de instanceof ElevatorAlightEdge) && !(de instanceof ElevatorBoardEdge)) continue;
            this.visibleStreetEdges.add(de);
        }
    }

    private int drawEdge(Edge e) {
        LineString geometry = ShowGraph.getOrCreateGeometry(e);
        Coordinate[] coords = geometry.getCoordinates();
        this.beginShape();
        for (Coordinate coord : coords) {
            this.vertex((float)this.toScreenX(coord.x), (float)this.toScreenY(coord.y));
        }
        this.endShape();
        return coords.length;
    }

    private void drawEdgeFast(Edge e) {
        Coordinate[] coords = ShowGraph.getOrCreateGeometry(e).getCoordinates();
        Coordinate c0 = coords[0];
        Coordinate c1 = coords[coords.length - 1];
        this.line((float)this.toScreenX(c0.x), (float)this.toScreenY(c0.y), (float)this.toScreenX(c1.x), (float)this.toScreenY(c1.y));
    }

    private void drawGraphPath(GraphPath<State, Edge, Vertex> gp) {
        for (State s : gp.states) {
            TraverseMode mode = s.getBackMode();
            Edge e = s.getBackEdge();
            if (e == null || !(e instanceof StreetEdge)) continue;
            StreetTraversalPermission stp = ((StreetEdge)e).getPermission();
            if (stp == StreetTraversalPermission.PEDESTRIAN) {
                this.stroke(0.0f, 200.0f, 0.0f);
                this.strokeWeight(6.0f);
                this.drawEdge(e);
                continue;
            }
            if (stp == StreetTraversalPermission.BICYCLE) {
                this.stroke(0.0f, 0.0f, 200.0f);
                this.strokeWeight(6.0f);
                this.drawEdge(e);
                continue;
            }
            if (stp == StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE) {
                this.stroke(0.0f, 200.0f, 200.0f);
                this.strokeWeight(6.0f);
                this.drawEdge(e);
                continue;
            }
            if (stp == StreetTraversalPermission.ALL) {
                this.stroke(200.0f, 200.0f, 200.0f);
                this.strokeWeight(6.0f);
                this.drawEdge(e);
                continue;
            }
            this.stroke(64.0f, 64.0f, 64.0f);
            this.strokeWeight(6.0f);
            this.drawEdge(e);
        }
        lastLabelY = -999.0;
        this.labelState((State)gp.states.getFirst(), "begin");
        this.labelState((State)gp.states.getLast(), "end");
    }

    private void labelState(State s, String str) {
        this.fill(240.0f, 240.0f, 240.0f);
        Vertex v = s.getVertex();
        this.drawVertex(v, 8.0);
        str = (String)str + " " + shortDateFormat.format(Instant.ofEpochSecond(s.getTimeSeconds()));
        str = (String)str + " [" + (int)s.getWeight() + "]";
        double x = this.toScreenX(v.getX()) + 10.0;
        double y = this.toScreenY(v.getY());
        double dy = y - lastLabelY;
        if (dy == 0.0) {
            y = lastLabelY + 20.0;
        } else if (Math.abs(dy) < 20.0) {
            y = lastLabelY + Math.signum(dy) * 20.0;
        }
        this.text((String)str, (float)x, (float)y);
        lastLabelY = y;
    }

    private void drawCoordinate(Coordinate c, double r) {
        this.noStroke();
        this.ellipse(this.toScreenX(c.x), this.toScreenY(c.y), r, r);
    }

    private void drawVertex(Vertex v, double r) {
        this.drawCoordinate(v.getCoordinate(), r);
    }

    private boolean drawSPT() {
        if (!this.sptVisible) {
            return true;
        }
        this.noFill();
        this.simpleSPT.draw();
        return true;
    }

    private void colorOverlappingBranches(LinkedBlockingQueue<SPTNode> queue) {
        HashMap<Vertex, Integer> stateHeight = new HashMap<Vertex, Integer>();
        for (SPTNode node : queue) {
            Integer height = (Integer)stateHeight.get(node.state.getVertex());
            height = height == null ? Integer.valueOf(0) : Integer.valueOf(height + 1);
            stateHeight.put(node.state.getVertex(), height);
            node.setHeight(height);
        }
    }

    private void drawNewEdges() {
        this.strokeWeight(1.0f);
        this.stroke(255.0f, 255.0f, 255.0f);
        this.noFill();
        while (!this.newSPTEdges.isEmpty()) {
            State leaf = this.newSPTEdges.poll();
            if (leaf == null || leaf.getBackEdge() == null) continue;
            this.drawEdge(leaf.getBackEdge());
        }
    }

    private void drawCoords() {
        this.fill(0.0f, 0.0f, 0.0f);
        this.stroke(30.0f, 128.0f, 30.0f);
        this.strokeWeight(1.0f);
        this.rect(3.0f, 3.0f, 303.0f, this.textAscent() + this.textDescent() + 6.0f);
        this.fill(128.0f, 128.0f, 256.0f);
        String output = lonFormatter.format(this.mouseModelX) + " " + latFormatter.format(this.mouseModelY);
        this.textAlign(37, 101);
        this.text(output, 6.0f, 6.0f);
    }

    private void drawVertices() {
        double METERS_PER_DEGREE_LAT = 111111.111111;
        boolean closeEnough = this.modelBounds.getHeight() * 111111.111111 / (double)this.width < 5.0;
        for (Vertex v : this.visibleVertices) {
            List states;
            if (this.drawTransitStopVertices && closeEnough && (v instanceof TransitStopVertex || v instanceof TransitPathwayNodeVertex || v instanceof TransitEntranceVertex || v instanceof TransitBoardingAreaVertex)) {
                this.fill(60.0f, 60.0f, 200.0f);
                this.drawVertex(v, 7.0);
            }
            if (this.drawExtraVertices && closeEnough && (v instanceof VehicleParkingEntranceVertex || v instanceof VehicleRentalPlace)) {
                this.fill(255.0f, 70.0f, 255.0f);
                this.drawVertex(v, 7.0);
            }
            if (this.drawStreetVertices && (v instanceof IntersectionVertex && ((IntersectionVertex)v).hasCyclingTrafficLight() || v instanceof ElevatorOnboardVertex || v instanceof ElevatorOffboardVertex || v instanceof ExitVertex || v instanceof TemporaryVertex || v instanceof SplitterVertex || v instanceof StreetLocation) && v instanceof IntersectionVertex && ((IntersectionVertex)v).hasCyclingTrafficLight()) {
                this.fill(120.0f, 60.0f, 60.0f);
                this.drawVertex(v, 5.0);
            }
            if (!this.drawMultistateVertices || this.spt == null || (states = this.spt.getStates(v)) == null) continue;
            this.fill(100.0f, 60.0f, 100.0f);
            this.drawVertex(v, states.size() * 2);
        }
    }

    private void drawHighlighted() {
        this.noFill();
        this.stroke(200.0f, 200.0f, 0.0f, 16.0f);
        this.strokeWeight(8.0f);
        if (this.drawHighlighted && this.highlightedEdges != null) {
            try {
                for (Edge e : this.highlightedEdges) {
                    this.drawEdge(e);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        if (this.highlightedGraphPath != null) {
            this.drawGraphPath(this.highlightedGraphPath);
        }
        if (this.highlightedEdge != null) {
            this.stroke(10.0f, 200.0f, 10.0f, 128.0f);
            this.strokeWeight(12.0f);
            this.drawEdge(this.highlightedEdge);
        }
        this.fill(255.0f, 127.0f, 0.0f);
        this.noStroke();
        if (this.highlightedVertices != null) {
            for (Vertex v : this.highlightedVertices) {
                this.drawVertex(v, 8.0);
            }
        }
        if (this.highlightedCoordinate != null) {
            this.fill(255.0f, 255.0f, 30.0f);
            this.drawCoordinate(this.highlightedCoordinate, 7.0);
        }
        this.noFill();
    }

    private boolean drawTransit(int startMillis) {
        if (this.drawTransitEdges) {
            this.stroke(40.0f, 40.0f, 128.0f, 30.0f);
            this.strokeWeight(4.0f);
            this.noFill();
            while (this.drawOffset < this.visibleTransitEdges.size()) {
                Edge e = this.visibleTransitEdges.get(this.drawOffset);
                this.drawEdge(e);
                ++this.drawOffset;
                if (this.drawOffset % 1000 != 0 || this.millis() - startMillis <= 26) continue;
                return false;
            }
        }
        return true;
    }

    private boolean drawLinks(int startMillis) {
        if (this.drawLinkEdges) {
            this.stroke(256.0f, 165.0f, 0.0f, 30.0f);
            this.strokeWeight(3.0f);
            this.noFill();
            while (this.drawOffset < this.visibleLinkEdges.size()) {
                Edge e = this.visibleLinkEdges.get(this.drawOffset);
                this.drawEdge(e);
                ++this.drawOffset;
                if (this.drawOffset % 1000 != 0 || this.millis() - startMillis <= 26) continue;
                return false;
            }
        }
        return true;
    }

    private boolean drawAll(int startMillis) {
        if (this.drawOffset == 0) {
            this.findVisibleElements();
            this.background(15);
        }
        if (this.drawStreetEdges) {
            this.stroke(30.0f, 128.0f, 30.0f);
            this.strokeWeight(1.0f);
            this.noFill();
            while (this.drawOffset < this.visibleStreetEdges.size()) {
                this.drawEdge(this.visibleStreetEdges.get(this.drawOffset));
                ++this.drawOffset;
                if (this.drawOffset % 1000 != 0 || this.millis() - startMillis <= 26) continue;
                return false;
            }
        }
        return true;
    }

    private void drawPartial(int startMillis) {
        this.background(15);
        this.stroke(30.0f, 128.0f, 30.0f);
        this.strokeWeight(1.0f);
        this.noFill();
        int drawIndex = 0;
        int drawStart = 0;
        int drawCount = 0;
        while ((long)drawStart < 40L && drawStart < this.visibleStreetEdges.size()) {
            if (this.drawFast) {
                this.drawEdgeFast(this.visibleStreetEdges.get(drawIndex));
            } else {
                this.drawEdge(this.visibleStreetEdges.get(drawIndex));
            }
            drawIndex = (int)((long)drawIndex + 40L);
            if (++drawCount % 1000 == 0 && this.millis() - startMillis > 26) break;
            if (drawIndex < this.visibleStreetEdges.size()) continue;
            drawIndex = ++drawStart;
        }
    }

    private void handleNewHighlights() {
        this.desaturate();
        this.noFill();
        this.stroke(256.0f, 0.0f, 0.0f, 128.0f);
        this.strokeWeight(6.0f);
        while (!this.newHighlightedEdges.isEmpty()) {
            Edge de = this.newHighlightedEdges.poll();
            if (de == null) continue;
            this.drawEdge(de);
            this.highlightedEdges.add(de);
        }
    }

    private void saveVideoFrame() {
        this.save("/home/syncopate/pathimage//" + this.videoFrameNumber++ + ".bmp");
    }

    private void resetVideoFrameNumber() {
        this.videoFrameNumber = 0;
    }

    private void desaturate() {
        float f = 8.0f;
        this.loadPixels();
        for (int i = 0; i < this.width * this.height; ++i) {
            int c = this.pixels[i];
            float r = this.red(c);
            float g = this.green(c);
            float b = this.blue(c);
            float avg = (r + g + b) / 3.0f;
            r += (avg - r) / 8.0f;
            g += (avg - g) / 8.0f;
            b += (avg - b) / 8.0f;
            this.pixels[i] = this.color(r, g, b);
        }
        this.updatePixels();
    }

    private double toScreenY(double y) {
        return ShowGraph.map((float)((float)y), (float)((float)this.modelBounds.getMinY()), (float)((float)this.modelBounds.getMaxY()), (float)this.getSize().height, (float)0.0f);
    }

    private double toScreenX(double x) {
        return ShowGraph.map((float)((float)x), (float)((float)this.modelBounds.getMinX()), (float)((float)this.modelBounds.getMaxX()), (float)0.0f, (float)this.getSize().width);
    }

    private double toModelY(double y) {
        return ShowGraph.map((float)((float)y), (float)0.0f, (float)this.getSize().height, (float)((float)this.modelBounds.getMaxY()), (float)((float)this.modelBounds.getMinY()));
    }

    private double toModelX(double x) {
        return ShowGraph.map((float)((float)x), (float)0.0f, (float)this.getSize().width, (float)((float)this.modelBounds.getMinX()), (float)((float)this.modelBounds.getMaxX()));
    }

    private void ellipse(double d, double e, double f, double g) {
        this.ellipse((float)d, (float)e, (float)f, (float)g);
    }

    static {
        shortDateFormat = DateTimeFormatter.ofPattern("HH:mm:ss z");
    }

    class SimpleSPT {
        private final HashMap<State, SPTNode> nodes = new HashMap();
        SPTNode root;

        SimpleSPT() {
        }

        public void add(State state) {
            SPTNode curNode = new SPTNode(state);
            SPTNode parentNode = this.nodes.get(state.getBackState());
            if (parentNode != null) {
                parentNode.children.add(curNode);
            } else {
                this.root = curNode;
            }
            curNode.parent = parentNode;
            this.nodes.put(state, curNode);
        }

        public void draw() {
            if (this.root == null) {
                return;
            }
            HashMap<Vertex, Integer> vertexHeight = new HashMap<Vertex, Integer>();
            this.root.drawRecursive(0, vertexHeight);
        }

        public LinkedBlockingQueue<SPTNode> getEdgeQueue() {
            LinkedBlockingQueue<SPTNode> ret = new LinkedBlockingQueue<SPTNode>();
            if (this.root != null) {
                this.root.addToEdgeQueue(ret);
            }
            return ret;
        }

        void setWeights() {
            if (this.root == null) {
                return;
            }
            this.root.setWeight();
        }
    }

    class SPTNode {
        State state;
        SPTNode parent;
        List<SPTNode> children;
        double weight = 0.0;
        public Integer height;

        SPTNode(State state) {
            this.state = state;
            this.height = null;
            this.children = new ArrayList<SPTNode>();
        }

        public void addToEdgeQueue(LinkedBlockingQueue<SPTNode> ret) {
            ret.add(this);
            for (SPTNode child : this.children) {
                child.addToEdgeQueue(ret);
            }
        }

        public void drawRecursive(int height, HashMap<Vertex, Integer> vertexStatesEncountered) {
            ShowGraph.this.colorMode(3);
            Integer vertexHeight = vertexStatesEncountered.get(this.state.getVertex());
            if (vertexHeight == null) {
                vertexHeight = 0;
            }
            if (vertexHeight > height) {
                height = vertexHeight;
            }
            vertexStatesEncountered.put(this.state.getVertex(), vertexHeight + 1);
            if (this.state.getBackEdge() != null) {
                ShowGraph.this.stroke(ShowGraph.this.color(height * 10 % 255, 255, 255));
                ShowGraph.this.strokeWeight((float)((double)ShowGraph.this.sptThickness * Math.pow(this.weight, ShowGraph.this.sptFlattening)));
                ShowGraph.this.drawEdge(this.state.getBackEdge());
            }
            for (SPTNode child : this.children) {
                child.drawRecursive(height, vertexStatesEncountered);
            }
            ShowGraph.this.colorMode(1);
        }

        public void draw(List<Integer> colors) {
            ShowGraph.this.colorMode(3);
            if (this.state.getBackEdge() != null) {
                ShowGraph.this.strokeWeight((float)((double)ShowGraph.this.sptThickness * Math.pow(this.weight, ShowGraph.this.sptFlattening)));
                ShowGraph.this.stroke(colors.get(this.height));
                ShowGraph.this.drawEdge(this.state.getBackEdge());
            }
            ShowGraph.this.colorMode(1);
        }

        public void setWeight() {
            this.weight = this.state.getWeight();
            for (SPTNode child : this.children) {
                child.setWeight();
                this.weight += child.weight;
            }
        }

        public void setHeight(Integer height) {
            this.height = height;
        }

        void addChild(SPTNode child) {
            this.children.add(child);
        }

        private int colorRamp(int aa) {
            int NHUES = 6;
            int HUELEN = 256;
            int RAMPLEN = NHUES * HUELEN;
            int BRIGHTNESS = 220;
            int hueIndex = (aa %= RAMPLEN) / HUELEN;
            int hue = hueIndex * (HUELEN / NHUES);
            int saturation = HUELEN - aa % HUELEN;
            return ShowGraph.this.color(hue, saturation, BRIGHTNESS);
        }
    }

    static class Trunk {
        public Edge edge;
        public Double trunkiness;

        Trunk(Edge edge, Double trunkiness) {
            this.edge = edge;
            this.trunkiness = trunkiness;
        }
    }
}

