/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental.datasources;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.entur.gbfs.v2_3.free_bike_status.GBFSBike;
import org.entur.gbfs.v2_3.free_bike_status.GBFSRentalUris;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleType;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStationUris;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalSystem;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalVehicle;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class GbfsFreeVehicleStatusMapper {
    private final VehicleRentalSystem system;
    @Nonnull
    private final Map<String, RentalVehicleType> vehicleTypes;

    public GbfsFreeVehicleStatusMapper(VehicleRentalSystem system, @Nullable Map<String, RentalVehicleType> vehicleTypes) {
        this.system = system;
        this.vehicleTypes = new HashMap<String, RentalVehicleType>(Objects.requireNonNullElse(vehicleTypes, Map.of()));
    }

    public VehicleRentalVehicle mapFreeVehicleStatus(GBFSBike vehicle) {
        if ((vehicle.getStationId() == null || vehicle.getStationId().isBlank()) && vehicle.getLon() != null && vehicle.getLat() != null) {
            VehicleRentalVehicle rentalVehicle = new VehicleRentalVehicle();
            rentalVehicle.id = new FeedScopedId(this.system.systemId, vehicle.getBikeId());
            rentalVehicle.system = this.system;
            rentalVehicle.name = new NonLocalizedString(this.getName(vehicle));
            rentalVehicle.longitude = vehicle.getLon();
            rentalVehicle.latitude = vehicle.getLat();
            rentalVehicle.vehicleType = this.vehicleTypes.getOrDefault(vehicle.getVehicleTypeId(), RentalVehicleType.getDefaultType(this.system.systemId));
            rentalVehicle.isReserved = vehicle.getIsReserved() != null ? vehicle.getIsReserved() : false;
            rentalVehicle.isDisabled = vehicle.getIsDisabled() != null ? vehicle.getIsDisabled() : false;
            rentalVehicle.lastReported = vehicle.getLastReported() != null ? Instant.ofEpochSecond((long)vehicle.getLastReported().doubleValue()) : null;
            rentalVehicle.currentRangeMeters = vehicle.getCurrentRangeMeters();
            rentalVehicle.pricingPlanId = vehicle.getPricingPlanId();
            GBFSRentalUris rentalUris = vehicle.getRentalUris();
            if (rentalUris != null) {
                String androidUri = rentalUris.getAndroid();
                String iosUri = rentalUris.getIos();
                String webUri = rentalUris.getWeb();
                rentalVehicle.rentalUris = new VehicleRentalStationUris(androidUri, iosUri, webUri);
            }
            return rentalVehicle;
        }
        return null;
    }

    private String getName(GBFSBike vehicle) {
        RentalVehicleType type;
        String typeId = vehicle.getVehicleTypeId();
        if (typeId != null && (type = this.vehicleTypes.get(typeId)) != null && type.name != null) {
            return type.name;
        }
        return RentalVehicleType.getDefaultType((String)this.system.systemId).name;
    }
}

