/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.metrics;

import io.micrometer.core.instrument.Tag;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.updater.spi.UpdateResult;
import org.opentripplanner.updater.trip.UrlUpdaterParameters;
import org.opentripplanner.updater.trip.metrics.BatchTripUpdateMetrics;
import org.opentripplanner.updater.trip.metrics.StreamingTripUpdateMetrics;

public class TripUpdateMetrics {
    public static final Consumer<UpdateResult> NOOP = ignored -> {};
    protected List<Tag> baseTags;

    TripUpdateMetrics(UrlUpdaterParameters parameters) {
        this.baseTags = List.of(Tag.of((String)"configRef", (String)parameters.configRef()), Tag.of((String)"url", (String)parameters.url()), Tag.of((String)"feedId", (String)parameters.feedId()));
    }

    public static Consumer<UpdateResult> batch(UrlUpdaterParameters parameters) {
        return TripUpdateMetrics.getConsumer(() -> {
            BatchTripUpdateMetrics metrics = new BatchTripUpdateMetrics(parameters);
            return metrics::setGauges;
        });
    }

    public static Consumer<UpdateResult> streaming(UrlUpdaterParameters parameters) {
        return TripUpdateMetrics.getConsumer(() -> {
            StreamingTripUpdateMetrics metrics = new StreamingTripUpdateMetrics(parameters);
            return metrics::setCounters;
        });
    }

    private static Consumer<UpdateResult> getConsumer(Supplier<Consumer<UpdateResult>> maker) {
        if (OTPFeature.ActuatorAPI.isOn()) {
            return maker.get();
        }
        return NOOP;
    }
}

