/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip;

import com.google.transit.realtime.GtfsRealtime;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.GraphWriterRunnable;
import org.opentripplanner.updater.GtfsRealtimeFuzzyTripMatcher;
import org.opentripplanner.updater.spi.UpdateResult;
import org.opentripplanner.updater.trip.BackwardsDelayPropagationType;
import org.opentripplanner.updater.trip.TimetableSnapshotSource;

class TripUpdateGraphWriterRunnable
implements GraphWriterRunnable {
    private final boolean fullDataset;
    private final List<GtfsRealtime.TripUpdate> updates;
    private final GtfsRealtimeFuzzyTripMatcher fuzzyTripMatcher;
    private final BackwardsDelayPropagationType backwardsDelayPropagationType;
    private final String feedId;
    private final Consumer<UpdateResult> sendMetrics;
    private final TimetableSnapshotSource snapshotSource;

    TripUpdateGraphWriterRunnable(TimetableSnapshotSource snapshotSource, GtfsRealtimeFuzzyTripMatcher fuzzyTripMatcher, BackwardsDelayPropagationType backwardsDelayPropagationType, boolean fullDataset, List<GtfsRealtime.TripUpdate> updates, String feedId, Consumer<UpdateResult> sendMetrics) {
        this.snapshotSource = snapshotSource;
        this.fuzzyTripMatcher = fuzzyTripMatcher;
        this.backwardsDelayPropagationType = backwardsDelayPropagationType;
        this.fullDataset = fullDataset;
        this.updates = Objects.requireNonNull(updates);
        this.feedId = Objects.requireNonNull(feedId);
        this.sendMetrics = sendMetrics;
    }

    @Override
    public void run(Graph graph, TransitModel transitModel) {
        UpdateResult result = this.snapshotSource.applyTripUpdates(this.fuzzyTripMatcher, this.backwardsDelayPropagationType, this.fullDataset, this.updates, this.feedId);
        this.sendMetrics.accept(result);
    }
}

