/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.transit.realtime.GtfsRealtime;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.GtfsRealtimeFuzzyTripMatcher;
import org.opentripplanner.updater.spi.GraphUpdater;
import org.opentripplanner.updater.spi.UpdateResult;
import org.opentripplanner.updater.spi.WriteToGraphCallback;
import org.opentripplanner.updater.trip.BackwardsDelayPropagationType;
import org.opentripplanner.updater.trip.MqttGtfsRealtimeUpdaterParameters;
import org.opentripplanner.updater.trip.TimetableSnapshotSource;
import org.opentripplanner.updater.trip.TripUpdateGraphWriterRunnable;
import org.opentripplanner.updater.trip.metrics.TripUpdateMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttGtfsRealtimeUpdater
implements GraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(MqttGtfsRealtimeUpdater.class);
    private final String url;
    private final String topic;
    private final String feedId;
    private final int qos;
    private final BackwardsDelayPropagationType backwardsDelayPropagationType;
    private final String clientId = "OpenTripPlanner-" + MqttClient.generateClientId();
    private final String configRef;
    private final MemoryPersistence persistence = new MemoryPersistence();
    private final TimetableSnapshotSource snapshotSource;
    private final Consumer<UpdateResult> recordMetrics;
    private WriteToGraphCallback saveResultOnGraph;
    private GtfsRealtimeFuzzyTripMatcher fuzzyTripMatcher = null;
    private MqttClient client;

    public MqttGtfsRealtimeUpdater(MqttGtfsRealtimeUpdaterParameters parameters, TransitModel transitModel, TimetableSnapshotSource snapshotSource) {
        this.configRef = parameters.configRef();
        this.url = parameters.url();
        this.topic = parameters.getTopic();
        this.feedId = parameters.feedId();
        this.qos = parameters.getQos();
        this.backwardsDelayPropagationType = parameters.getBackwardsDelayPropagationType();
        this.snapshotSource = snapshotSource;
        if (parameters.getFuzzyTripMatching()) {
            this.fuzzyTripMatcher = new GtfsRealtimeFuzzyTripMatcher(new DefaultTransitService(transitModel));
        }
        this.recordMetrics = TripUpdateMetrics.streaming(parameters);
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public void run() throws Exception {
        this.client = new MqttClient(this.url, this.clientId, (MqttClientPersistence)this.persistence);
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setCleanSession(true);
        connOpts.setAutomaticReconnect(true);
        URI parsedUrl = new URI(this.url);
        if (parsedUrl.getUserInfo() != null) {
            String[] userinfo = parsedUrl.getUserInfo().split(":");
            connOpts.setUserName(userinfo[0]);
            connOpts.setPassword(userinfo[1].toCharArray());
        }
        this.client.setCallback((MqttCallback)new Callback());
        LOG.debug("Connecting to broker: {}", (Object)this.url);
        this.client.connect(connOpts);
    }

    @Override
    public void teardown() {
        try {
            this.client.disconnect();
        }
        catch (MqttException e) {
            LOG.error("Error disconnecting", (Throwable)e);
        }
    }

    @Override
    public String getConfigRef() {
        return this.configRef;
    }

    private class Callback
    implements MqttCallbackExtended {
        private Callback() {
        }

        public void connectComplete(boolean reconnect, String serverURI) {
            try {
                LOG.debug("Connected");
                MqttGtfsRealtimeUpdater.this.client.subscribe(MqttGtfsRealtimeUpdater.this.topic, MqttGtfsRealtimeUpdater.this.qos);
            }
            catch (MqttException e) {
                LOG.warn("Could not subscribe to: {}", (Object)MqttGtfsRealtimeUpdater.this.topic);
            }
        }

        public void connectionLost(Throwable cause) {
            LOG.debug("Disconnected");
        }

        public void messageArrived(String topic, MqttMessage message) {
            ArrayList<GtfsRealtime.TripUpdate> updates = null;
            boolean fullDataset = true;
            try {
                GtfsRealtime.FeedMessage feedMessage = (GtfsRealtime.FeedMessage)GtfsRealtime.FeedMessage.PARSER.parseFrom(message.getPayload());
                List<GtfsRealtime.FeedEntity> feedEntityList = feedMessage.getEntityList();
                if (feedMessage.hasHeader() && feedMessage.getHeader().hasIncrementality() && feedMessage.getHeader().getIncrementality().equals((Object)GtfsRealtime.FeedHeader.Incrementality.DIFFERENTIAL)) {
                    fullDataset = false;
                }
                updates = new ArrayList<GtfsRealtime.TripUpdate>(feedEntityList.size());
                for (GtfsRealtime.FeedEntity feedEntity : feedEntityList) {
                    if (!feedEntity.hasTripUpdate()) continue;
                    updates.add(feedEntity.getTripUpdate());
                }
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error("Could not decode gtfs-rt message:", (Throwable)e);
            }
            if (updates != null) {
                MqttGtfsRealtimeUpdater.this.saveResultOnGraph.execute(new TripUpdateGraphWriterRunnable(MqttGtfsRealtimeUpdater.this.snapshotSource, MqttGtfsRealtimeUpdater.this.fuzzyTripMatcher, MqttGtfsRealtimeUpdater.this.backwardsDelayPropagationType, fullDataset, updates, MqttGtfsRealtimeUpdater.this.feedId, MqttGtfsRealtimeUpdater.this.recordMetrics));
            }
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
        }
    }
}

