/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.transit.realtime.GtfsRealtime;
import de.mfdz.MfdzRealtimeExtensions;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opentripplanner.framework.io.HttpUtils;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.trip.PollingTripUpdaterParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsRealtimeTripUpdateSource {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsRealtimeTripUpdateSource.class);
    private final String feedId;
    private final String url;
    private final HttpHeaders headers;
    private boolean fullDataset = true;
    private final ExtensionRegistry registry = ExtensionRegistry.newInstance();

    public GtfsRealtimeTripUpdateSource(PollingTripUpdaterParameters config) {
        this.feedId = config.feedId();
        this.url = config.url();
        this.headers = HttpHeaders.of().acceptProtobuf().add(config.headers()).build();
        MfdzRealtimeExtensions.registerAllExtensions(this.registry);
    }

    public List<GtfsRealtime.TripUpdate> getUpdates() {
        ArrayList<GtfsRealtime.TripUpdate> updates = null;
        this.fullDataset = true;
        try {
            InputStream is = HttpUtils.openInputStream(URI.create(this.url), this.headers.asMap());
            if (is != null) {
                GtfsRealtime.FeedMessage feedMessage = GtfsRealtime.FeedMessage.parseFrom(is, (ExtensionRegistryLite)this.registry);
                List<GtfsRealtime.FeedEntity> feedEntityList = feedMessage.getEntityList();
                if (feedMessage.hasHeader() && feedMessage.getHeader().hasIncrementality() && feedMessage.getHeader().getIncrementality().equals((Object)GtfsRealtime.FeedHeader.Incrementality.DIFFERENTIAL)) {
                    this.fullDataset = false;
                }
                updates = new ArrayList<GtfsRealtime.TripUpdate>(feedEntityList.size());
                for (GtfsRealtime.FeedEntity feedEntity : feedEntityList) {
                    if (!feedEntity.hasTripUpdate()) continue;
                    updates.add(feedEntity.getTripUpdate());
                }
            } else {
                LOG.error("GTFS-RT feed at {} did not return usable data", (Object)this.url);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to parse GTFS-RT feed from {}", (Object)this.url, (Object)e);
        }
        return updates;
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addStr("feedId", this.feedId).addStr("url", this.url).toString();
    }

    public boolean getFullDatasetValueOfLastUpdates() {
        return this.fullDataset;
    }

    static interface Parameters {
        public String getFeedId();

        public String getUrl();

        public Map<String, String> headers();
    }
}

