/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip;

import com.google.transit.realtime.GtfsRealtime;
import de.mfdz.MfdzRealtimeExtensions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.gtfs.mapping.PickDropMapper;
import org.opentripplanner.model.PickDrop;

final class AddedStopTime {
    @Nullable
    private final PickDrop pickup;
    @Nullable
    private final PickDrop dropOff;
    public static final PickDrop DEFAULT_PICK_DROP = PickDrop.SCHEDULED;

    AddedStopTime(@Nullable PickDrop pickup, @Nullable PickDrop dropOff) {
        this.pickup = pickup;
        this.dropOff = dropOff;
    }

    PickDrop pickup() {
        return Objects.requireNonNullElse(this.pickup, DEFAULT_PICK_DROP);
    }

    PickDrop dropOff() {
        return Objects.requireNonNullElse(this.dropOff, DEFAULT_PICK_DROP);
    }

    static AddedStopTime ofStopTime(GtfsRealtime.TripUpdate.StopTimeUpdate props) {
        if (props.getStopTimeProperties().hasExtension(MfdzRealtimeExtensions.stopTimeProperties)) {
            MfdzRealtimeExtensions.StopTimePropertiesExtension ext = (MfdzRealtimeExtensions.StopTimePropertiesExtension)props.getStopTimeProperties().getExtension(MfdzRealtimeExtensions.stopTimeProperties);
            MfdzRealtimeExtensions.StopTimePropertiesExtension.DropOffPickupType pickup = ext.getPickupType();
            MfdzRealtimeExtensions.StopTimePropertiesExtension.DropOffPickupType dropOff = ext.getDropoffType();
            PickDrop dropOffType = PickDropMapper.map(dropOff.getNumber());
            PickDrop pickupType = PickDropMapper.map(pickup.getNumber());
            return new AddedStopTime(pickupType, dropOffType);
        }
        PickDrop pickDrop = AddedStopTime.toPickDrop(props.getScheduleRelationship());
        return new AddedStopTime(pickDrop, pickDrop);
    }

    private static PickDrop toPickDrop(GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship scheduleRelationship) {
        return switch (scheduleRelationship) {
            default -> throw new IncompatibleClassChangeError();
            case GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SCHEDULED, GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.NO_DATA, GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.UNSCHEDULED -> PickDrop.SCHEDULED;
            case GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SKIPPED -> PickDrop.CANCELLED;
        };
    }
}

