/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HttpHeaders {
    private final Map<String, String> headers;

    private HttpHeaders(Builder builder) {
        this.headers = Map.copyOf(builder.headers);
    }

    public static Builder of() {
        return new Builder();
    }

    public static HttpHeaders of(Map<String, String> map) {
        if (map.isEmpty()) {
            return HttpHeaders.empty();
        }
        Builder builder = HttpHeaders.of();
        for (Map.Entry<String, String> e : map.entrySet()) {
            builder.add(e.getKey(), e.getValue());
        }
        return builder.build();
    }

    public static HttpHeaders empty() {
        return HttpHeaders.of().build();
    }

    public Map<String, String> asMap() {
        return this.headers;
    }

    public String toString() {
        return HttpHeaders.class.getSimpleName() + this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHeaders that = (HttpHeaders)o;
        return Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.headers);
    }

    public static class Builder {
        private final HashMap<String, String> headers = new HashMap();

        public Builder acceptApplicationXML() {
            this.headers.put("Accept", "application/xml");
            return this;
        }

        public Builder acceptProtobuf() {
            this.headers.put("Accept", "application/x-google-protobuf, application/x-protobuf, application/protobuf, application/octet-stream, */*");
            return this;
        }

        public Builder add(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder add(HttpHeaders other) {
            this.headers.putAll(other.asMap());
            return this;
        }

        public HttpHeaders build() {
            return new HttpHeaders(this);
        }
    }
}

