/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.alert;

import com.google.transit.realtime.GtfsRealtime;
import java.io.InputStream;
import java.net.URI;
import org.opentripplanner.framework.io.HttpUtils;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.routing.impl.TransitAlertServiceImpl;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.GtfsRealtimeFuzzyTripMatcher;
import org.opentripplanner.updater.alert.AlertsUpdateHandler;
import org.opentripplanner.updater.alert.GtfsRealtimeAlertsUpdaterParameters;
import org.opentripplanner.updater.alert.TransitAlertProvider;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.spi.PollingGraphUpdater;
import org.opentripplanner.updater.spi.WriteToGraphCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsRealtimeAlertsUpdater
extends PollingGraphUpdater
implements TransitAlertProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsRealtimeAlertsUpdater.class);
    private final String url;
    private final AlertsUpdateHandler updateHandler;
    private final TransitAlertService transitAlertService;
    private final HttpHeaders headers;
    private WriteToGraphCallback saveResultOnGraph;
    private Long lastTimestamp = Long.MIN_VALUE;

    public GtfsRealtimeAlertsUpdater(GtfsRealtimeAlertsUpdaterParameters config, TransitModel transitModel) {
        super(config);
        this.url = config.url();
        this.headers = HttpHeaders.of().acceptProtobuf().add(config.headers()).build();
        TransitAlertServiceImpl transitAlertService = new TransitAlertServiceImpl(transitModel);
        GtfsRealtimeFuzzyTripMatcher fuzzyTripMatcher = config.fuzzyTripMatching() ? new GtfsRealtimeFuzzyTripMatcher(new DefaultTransitService(transitModel)) : null;
        this.transitAlertService = transitAlertService;
        this.updateHandler = new AlertsUpdateHandler();
        this.updateHandler.setEarlyStart(config.earlyStartSec());
        this.updateHandler.setFeedId(config.feedId());
        this.updateHandler.setTransitAlertService(transitAlertService);
        this.updateHandler.setFuzzyTripMatcher(fuzzyTripMatcher);
        LOG.info("Creating real-time alert updater running every {} seconds : {}", (Object)this.pollingPeriodSeconds(), (Object)this.url);
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public TransitAlertService getTransitAlertService() {
        return this.transitAlertService;
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addStr("url", this.url).toString();
    }

    @Override
    protected void runPolling() {
        try {
            InputStream data = HttpUtils.getData(URI.create(this.url), this.headers.asMap());
            if (data == null) {
                throw new RuntimeException("Failed to get data from url " + this.url);
            }
            GtfsRealtime.FeedMessage feed = (GtfsRealtime.FeedMessage)GtfsRealtime.FeedMessage.PARSER.parseFrom(data);
            long feedTimestamp = feed.getHeader().getTimestamp();
            if (feedTimestamp == this.lastTimestamp) {
                LOG.debug("Ignoring feed with a timestamp that has not been updated from {}", (Object)this.url);
                return;
            }
            if (feedTimestamp < this.lastTimestamp) {
                LOG.info("Ignoring feed with older than previous timestamp from {}", (Object)this.url);
                return;
            }
            this.saveResultOnGraph.execute((graph, transitModel) -> this.updateHandler.update(feed));
            this.lastTimestamp = feedTimestamp;
        }
        catch (Exception e) {
            LOG.error("Error reading gtfs-realtime feed from " + this.url, (Throwable)e);
        }
    }
}

