/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.alert;

import com.google.transit.realtime.GtfsRealtime;
import java.util.ArrayList;
import java.util.HashMap;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.TranslatedString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.gtfs.mapping.DirectionMapper;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TimePeriod;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.alertpatch.TransitAlertBuilder;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.updater.GtfsRealtimeFuzzyTripMatcher;
import org.opentripplanner.updater.alert.GtfsRealtimeCauseMapper;
import org.opentripplanner.updater.alert.GtfsRealtimeEffectMapper;
import org.opentripplanner.updater.alert.GtfsRealtimeSeverityMapper;

public class AlertsUpdateHandler {
    private static final int MISSING_INT_FIELD_VALUE = -1;
    private String feedId;
    private TransitAlertService transitAlertService;
    private long earlyStart;
    private GtfsRealtimeFuzzyTripMatcher fuzzyTripMatcher;
    private final DirectionMapper directionMapper = new DirectionMapper(DataImportIssueStore.NOOP);

    public void update(GtfsRealtime.FeedMessage message) {
        ArrayList<TransitAlert> alerts = new ArrayList<TransitAlert>();
        for (GtfsRealtime.FeedEntity entity : message.getEntityList()) {
            if (!entity.hasAlert()) continue;
            GtfsRealtime.Alert alert = entity.getAlert();
            String id = entity.getId();
            alerts.add(this.mapAlert(id, alert));
        }
        this.transitAlertService.setAlerts(alerts);
    }

    public void setFeedId(String feedId) {
        if (feedId != null) {
            this.feedId = feedId.intern();
        }
    }

    public void setTransitAlertService(TransitAlertService transitAlertService) {
        this.transitAlertService = transitAlertService;
    }

    public void setEarlyStart(long earlyStart) {
        this.earlyStart = earlyStart;
    }

    public void setFuzzyTripMatcher(GtfsRealtimeFuzzyTripMatcher fuzzyTripMatcher) {
        this.fuzzyTripMatcher = fuzzyTripMatcher;
    }

    private TransitAlert mapAlert(String id, GtfsRealtime.Alert alert) {
        TransitAlertBuilder alertBuilder = TransitAlert.of(new FeedScopedId(this.feedId, id)).withDescriptionText(this.deBuffer(alert.getDescriptionText())).withHeaderText(this.deBuffer(alert.getHeaderText())).withUrl(this.deBuffer(alert.getUrl())).withSeverity(GtfsRealtimeSeverityMapper.getAlertSeverityForGtfsRtSeverity(alert.getSeverityLevel())).withCause(GtfsRealtimeCauseMapper.getAlertCauseForGtfsRtCause(alert.getCause())).withEffect(GtfsRealtimeEffectMapper.getAlertEffectForGtfsRtEffect(alert.getEffect()));
        ArrayList<TimePeriod> periods = new ArrayList<TimePeriod>();
        if (alert.getActivePeriodCount() > 0) {
            for (GtfsRealtime.TimeRange activePeriod : alert.getActivePeriodList()) {
                long realStart = activePeriod.hasStart() ? activePeriod.getStart() : 0L;
                long start = activePeriod.hasStart() ? realStart - this.earlyStart : 0L;
                long end = activePeriod.hasEnd() ? activePeriod.getEnd() : Long.MAX_VALUE;
                periods.add(new TimePeriod(start, end));
            }
        } else {
            periods.add(new TimePeriod(0L, Long.MAX_VALUE));
        }
        alertBuilder.addTimePeriods(periods);
        for (GtfsRealtime.EntitySelector informed : alert.getInformedEntityList()) {
            if (this.fuzzyTripMatcher != null && informed.hasTrip()) {
                GtfsRealtime.TripDescriptor trip = this.fuzzyTripMatcher.match(this.feedId, informed.getTrip());
                informed = informed.toBuilder().setTrip(trip).build();
            }
            String routeId = null;
            if (informed.hasRouteId()) {
                routeId = informed.getRouteId();
            }
            int directionId = -1;
            if (informed.hasDirectionId()) {
                directionId = informed.getDirectionId();
            }
            String tripId = null;
            if (informed.hasTrip() && informed.getTrip().hasTripId()) {
                tripId = informed.getTrip().getTripId();
            }
            String stopId = null;
            if (informed.hasStopId()) {
                stopId = informed.getStopId();
            }
            String agencyId = null;
            if (informed.hasAgencyId()) {
                agencyId = informed.getAgencyId().intern();
            }
            int routeType = -1;
            if (informed.hasRouteType()) {
                routeType = informed.getRouteType();
            }
            if (tripId != null) {
                if (stopId != null) {
                    alertBuilder.addEntity(new EntitySelector.StopAndTrip(new FeedScopedId(this.feedId, stopId), new FeedScopedId(this.feedId, tripId)));
                    continue;
                }
                alertBuilder.addEntity(new EntitySelector.Trip(new FeedScopedId(this.feedId, tripId)));
                continue;
            }
            if (routeId != null) {
                if (stopId != null) {
                    alertBuilder.addEntity(new EntitySelector.StopAndRoute(new FeedScopedId(this.feedId, stopId), new FeedScopedId(this.feedId, routeId)));
                    continue;
                }
                if (directionId != -1) {
                    alertBuilder.addEntity(new EntitySelector.DirectionAndRoute(new FeedScopedId(this.feedId, routeId), this.directionMapper.map(directionId)));
                    continue;
                }
                alertBuilder.addEntity(new EntitySelector.Route(new FeedScopedId(this.feedId, routeId)));
                continue;
            }
            if (stopId != null) {
                alertBuilder.addEntity(new EntitySelector.Stop(new FeedScopedId(this.feedId, stopId)));
                continue;
            }
            if (agencyId != null) {
                FeedScopedId feedScopedAgencyId = new FeedScopedId(this.feedId, agencyId);
                if (routeType != -1) {
                    alertBuilder.addEntity(new EntitySelector.RouteTypeAndAgency(feedScopedAgencyId, routeType));
                    continue;
                }
                alertBuilder.addEntity(new EntitySelector.Agency(feedScopedAgencyId));
                continue;
            }
            if (routeType != -1) {
                alertBuilder.addEntity(new EntitySelector.RouteType(this.feedId, routeType));
                continue;
            }
            String description = "Entity selector: " + informed;
            alertBuilder.addEntity(new EntitySelector.Unknown(description));
        }
        if (!alertBuilder.hasEntities()) {
            alertBuilder.addEntity(new EntitySelector.Unknown("Alert had no entities"));
        }
        return (TransitAlert)alertBuilder.build();
    }

    private I18NString deBuffer(GtfsRealtime.TranslatedString input) {
        HashMap<String, String> translations = new HashMap<String, String>();
        for (GtfsRealtime.TranslatedString.Translation translation : input.getTranslationList()) {
            String language = translation.getLanguage();
            String string = translation.getText();
            translations.put(language, string);
        }
        return translations.isEmpty() ? null : TranslatedString.getI18NString(translations, true, true);
    }
}

