/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import gnu.trove.set.TIntSet;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.ext.flex.FlexIndex;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.routing.stoptimes.ArrivalDeparture;
import org.opentripplanner.transit.model.basic.Notice;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.GroupOfRoutes;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopLocationsGroup;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.updater.GraphUpdaterStatus;

public interface TransitService {
    public Collection<String> getFeedIds();

    public Collection<Agency> getAgencies();

    public Optional<Agency> findAgencyById(FeedScopedId var1);

    public FeedInfo getFeedInfo(String var1);

    public Collection<Operator> getOperators();

    public Collection<Notice> getNoticesByEntity(AbstractTransitEntity<?, ?> var1);

    public TripPattern getTripPatternForId(FeedScopedId var1);

    public Collection<TripPattern> getAllTripPatterns();

    public Collection<Notice> getNotices();

    public Station getStationById(FeedScopedId var1);

    public MultiModalStation getMultiModalStation(FeedScopedId var1);

    public Collection<Station> getStations();

    public Integer getServiceCodeForId(FeedScopedId var1);

    public TIntSet getServiceCodesRunningForDate(LocalDate var1);

    public Agency getAgencyForId(FeedScopedId var1);

    public Route getRouteForId(FeedScopedId var1);

    public Set<Route> getRoutesForStop(StopLocation var1);

    public Collection<TripPattern> getPatternsForStop(StopLocation var1);

    public Collection<TripPattern> getPatternsForStop(StopLocation var1, boolean var2);

    public Collection<Trip> getTripsForStop(StopLocation var1);

    public Collection<Operator> getAllOperators();

    public Operator getOperatorForId(FeedScopedId var1);

    public RegularStop getRegularStop(FeedScopedId var1);

    public Collection<StopLocation> listStopLocations();

    public Collection<RegularStop> listRegularStops();

    public StopLocation getStopLocation(FeedScopedId var1);

    public Collection<StopLocationsGroup> listStopLocationGroups();

    public StopLocationsGroup getStopLocationsGroup(FeedScopedId var1);

    public AreaStop getAreaStop(FeedScopedId var1);

    public Trip getTripForId(FeedScopedId var1);

    public Collection<Trip> getAllTrips();

    public Collection<Route> getAllRoutes();

    public TripPattern getPatternForTrip(Trip var1);

    public TripPattern getPatternForTrip(Trip var1, LocalDate var2);

    public Collection<TripPattern> getPatternsForRoute(Route var1);

    public MultiModalStation getMultiModalStationForStation(Station var1);

    public List<StopTimesInPattern> stopTimesForStop(StopLocation var1, Instant var2, Duration var3, int var4, ArrivalDeparture var5, boolean var6);

    public List<StopTimesInPattern> getStopTimesForStop(StopLocation var1, LocalDate var2, ArrivalDeparture var3, boolean var4);

    public List<TripTimeOnDate> stopTimesForPatternAtStop(StopLocation var1, TripPattern var2, Instant var3, Duration var4, int var5, ArrivalDeparture var6, boolean var7);

    public Collection<GroupOfRoutes> getGroupsOfRoutes();

    public Collection<Route> getRoutesForGroupOfRoutes(GroupOfRoutes var1);

    public GroupOfRoutes getGroupOfRoutesForId(FeedScopedId var1);

    public Timetable getTimetableForTripPattern(TripPattern var1, LocalDate var2);

    public TripPattern getRealtimeAddedTripPattern(FeedScopedId var1, LocalDate var2);

    public boolean hasRealtimeAddedTripPatterns();

    public TripOnServiceDate getTripOnServiceDateForTripAndDay(TripIdAndServiceDate var1);

    public TripOnServiceDate getTripOnServiceDateById(FeedScopedId var1);

    public Collection<TripOnServiceDate> getAllTripOnServiceDates();

    public Set<TransitMode> getTransitModes();

    public Collection<PathTransfer> getTransfersByStop(StopLocation var1);

    public TransitLayer getTransitLayer();

    public TransitLayer getRealtimeTransitLayer();

    public CalendarService getCalendarService();

    public ZoneId getTimeZone();

    public TransitAlertService getTransitAlertService();

    public FlexIndex getFlexIndex();

    public ZonedDateTime getTransitServiceEnds();

    public ZonedDateTime getTransitServiceStarts();

    public TransferService getTransferService();

    public boolean transitFeedCovers(Instant var1);

    public Collection<RegularStop> findRegularStop(Envelope var1);

    public Collection<AreaStop> findAreaStops(Envelope var1);

    public GraphUpdaterStatus getUpdaterStatus();
}

