/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.ext.flex.FlexIndex;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.routing.stoptimes.ArrivalDeparture;
import org.opentripplanner.routing.stoptimes.StopTimesHelper;
import org.opentripplanner.transit.model.basic.Notice;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.GroupOfRoutes;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopLocationsGroup;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.service.TransitEditorService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.transit.service.TransitModelIndex;
import org.opentripplanner.updater.GraphUpdaterStatus;

public class DefaultTransitService
implements TransitEditorService {
    private final TransitModel transitModel;
    private final TransitModelIndex transitModelIndex;
    private TimetableSnapshot timetableSnapshot;

    @Inject
    public DefaultTransitService(TransitModel transitModel) {
        this.transitModel = transitModel;
        this.transitModelIndex = transitModel.getTransitModelIndex();
    }

    @Override
    public Collection<String> getFeedIds() {
        return this.transitModel.getFeedIds();
    }

    @Override
    public Collection<Agency> getAgencies() {
        return this.transitModel.getAgencies();
    }

    @Override
    public Optional<Agency> findAgencyById(FeedScopedId id) {
        return this.transitModel.findAgencyById(id);
    }

    @Override
    public FeedInfo getFeedInfo(String feedId) {
        return this.transitModel.getFeedInfo(feedId);
    }

    @Override
    public void addAgency(Agency agency) {
        this.transitModel.addAgency(agency);
    }

    @Override
    public void addFeedInfo(FeedInfo info) {
        this.transitModel.addFeedInfo(info);
    }

    @Override
    public Collection<Operator> getOperators() {
        return this.transitModel.getOperators();
    }

    @Override
    public Collection<Notice> getNoticesByEntity(AbstractTransitEntity<?, ?> entity) {
        return this.transitModel.getNoticesByElement().get(entity);
    }

    @Override
    public TripPattern getTripPatternForId(FeedScopedId id) {
        return this.transitModel.getTripPatternForId(id);
    }

    @Override
    public Collection<TripPattern> getAllTripPatterns() {
        return this.transitModel.getAllTripPatterns();
    }

    @Override
    public Collection<Notice> getNotices() {
        return this.transitModel.getNoticesByElement().values();
    }

    @Override
    public Station getStationById(FeedScopedId id) {
        return this.transitModel.getStopModel().getStationById(id);
    }

    @Override
    public MultiModalStation getMultiModalStation(FeedScopedId id) {
        return this.transitModel.getStopModel().getMultiModalStation(id);
    }

    @Override
    public Collection<Station> getStations() {
        return this.transitModel.getStopModel().listStations();
    }

    @Override
    public Integer getServiceCodeForId(FeedScopedId id) {
        return this.transitModel.getServiceCodes().get(id);
    }

    @Override
    public TIntSet getServiceCodesRunningForDate(LocalDate serviceDate) {
        return this.transitModelIndex.getServiceCodesRunningForDate().getOrDefault(serviceDate, (TIntSet)new TIntHashSet());
    }

    @Override
    public AreaStop getAreaStop(FeedScopedId id) {
        return this.transitModel.getStopModel().getAreaStop(id);
    }

    @Override
    public Agency getAgencyForId(FeedScopedId id) {
        return this.transitModelIndex.getAgencyForId(id);
    }

    @Override
    public RegularStop getRegularStop(FeedScopedId id) {
        return this.transitModel.getStopModel().getRegularStop(id);
    }

    @Override
    public Route getRouteForId(FeedScopedId id) {
        return this.transitModelIndex.getRouteForId(id);
    }

    @Override
    public void addRoutes(Route route) {
        this.transitModelIndex.addRoutes(route);
    }

    @Override
    public Set<Route> getRoutesForStop(StopLocation stop) {
        return this.transitModelIndex.getRoutesForStop(stop);
    }

    @Override
    public Collection<TripPattern> getPatternsForStop(StopLocation stop) {
        return this.transitModelIndex.getPatternsForStop(stop);
    }

    @Override
    public Collection<Trip> getTripsForStop(StopLocation stop) {
        return this.transitModelIndex.getTripsForStop(stop);
    }

    @Override
    public Collection<Operator> getAllOperators() {
        return this.transitModelIndex.getAllOperators();
    }

    @Override
    public Operator getOperatorForId(FeedScopedId id) {
        return this.transitModelIndex.getOperatorForId().get(id);
    }

    @Override
    public Collection<StopLocation> listStopLocations() {
        return this.transitModel.getStopModel().listStopLocations();
    }

    @Override
    public Collection<RegularStop> listRegularStops() {
        return this.transitModel.getStopModel().listRegularStops();
    }

    @Override
    public StopLocation getStopLocation(FeedScopedId id) {
        return this.transitModel.getStopModel().getStopLocation(id);
    }

    @Override
    public Collection<StopLocationsGroup> listStopLocationGroups() {
        return this.transitModel.getStopModel().listStopLocationGroups();
    }

    @Override
    public StopLocationsGroup getStopLocationsGroup(FeedScopedId id) {
        return this.transitModel.getStopModel().getStopLocationsGroup(id);
    }

    @Override
    public Trip getTripForId(FeedScopedId id) {
        return this.transitModelIndex.getTripForId().get(id);
    }

    @Override
    public Collection<Trip> getAllTrips() {
        return this.transitModelIndex.getTripForId().values();
    }

    @Override
    public Collection<Route> getAllRoutes() {
        return this.transitModelIndex.getAllRoutes();
    }

    @Override
    public TripPattern getPatternForTrip(Trip trip) {
        return this.transitModelIndex.getPatternForTrip().get(trip);
    }

    @Override
    public TripPattern getPatternForTrip(Trip trip, LocalDate serviceDate) {
        TripPattern realtimePattern = this.getRealtimeAddedTripPattern(trip.getId(), serviceDate);
        if (realtimePattern != null) {
            return realtimePattern;
        }
        return this.getPatternForTrip(trip);
    }

    @Override
    public Collection<TripPattern> getPatternsForRoute(Route route) {
        return this.transitModelIndex.getPatternsForRoute().get((Object)route);
    }

    @Override
    public MultiModalStation getMultiModalStationForStation(Station station) {
        return this.transitModel.getStopModel().getMultiModalStationForStation(station);
    }

    @Override
    public List<StopTimesInPattern> stopTimesForStop(StopLocation stop, Instant startTime, Duration timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture, boolean includeCancelledTrips) {
        return StopTimesHelper.stopTimesForStop(this, stop, startTime, timeRange, numberOfDepartures, arrivalDeparture, includeCancelledTrips);
    }

    @Override
    public List<StopTimesInPattern> getStopTimesForStop(StopLocation stop, LocalDate serviceDate, ArrivalDeparture arrivalDeparture, boolean includeCancellations) {
        return StopTimesHelper.stopTimesForStop(this, stop, serviceDate, arrivalDeparture, includeCancellations);
    }

    @Override
    public List<TripTimeOnDate> stopTimesForPatternAtStop(StopLocation stop, TripPattern pattern, Instant startTime, Duration timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture, boolean includeCancellations) {
        return StopTimesHelper.stopTimesForPatternAtStop(this, stop, pattern, startTime, timeRange, numberOfDepartures, arrivalDeparture, includeCancellations);
    }

    @Override
    public Collection<TripPattern> getPatternsForStop(StopLocation stop, boolean includeRealtimeUpdates) {
        return this.transitModel.getTransitModelIndex().getPatternsForStop(stop, includeRealtimeUpdates ? this.lazyGetTimeTableSnapShot() : null);
    }

    @Override
    public Collection<GroupOfRoutes> getGroupsOfRoutes() {
        return this.transitModelIndex.getRoutesForGroupOfRoutes().keySet();
    }

    @Override
    public Collection<Route> getRoutesForGroupOfRoutes(GroupOfRoutes groupOfRoutes) {
        return this.transitModelIndex.getRoutesForGroupOfRoutes().get((Object)groupOfRoutes);
    }

    @Override
    public GroupOfRoutes getGroupOfRoutesForId(FeedScopedId id) {
        return this.transitModelIndex.getGroupOfRoutesForId().get(id);
    }

    @Override
    public Timetable getTimetableForTripPattern(TripPattern tripPattern, LocalDate serviceDate) {
        TimetableSnapshot timetableSnapshot = this.lazyGetTimeTableSnapShot();
        return timetableSnapshot != null ? timetableSnapshot.resolve(tripPattern, serviceDate) : tripPattern.getScheduledTimetable();
    }

    @Override
    public TripPattern getRealtimeAddedTripPattern(FeedScopedId tripId, LocalDate serviceDate) {
        TimetableSnapshot timetableSnapshot = this.lazyGetTimeTableSnapShot();
        if (timetableSnapshot == null) {
            return null;
        }
        return timetableSnapshot.getRealtimeAddedTripPattern(tripId, serviceDate);
    }

    @Override
    public boolean hasRealtimeAddedTripPatterns() {
        TimetableSnapshot timetableSnapshot = this.lazyGetTimeTableSnapShot();
        if (timetableSnapshot == null) {
            return false;
        }
        return timetableSnapshot.hasRealtimeAddedTripPatterns();
    }

    private TimetableSnapshot lazyGetTimeTableSnapShot() {
        if (this.timetableSnapshot == null) {
            this.timetableSnapshot = this.transitModel.getTimetableSnapshot();
        }
        return this.timetableSnapshot;
    }

    @Override
    public TripOnServiceDate getTripOnServiceDateById(FeedScopedId datedServiceJourneyId) {
        TripOnServiceDate tripOnServiceDate;
        TimetableSnapshot timetableSnapshot = this.lazyGetTimeTableSnapShot();
        if (timetableSnapshot != null && (tripOnServiceDate = timetableSnapshot.getRealtimeAddedTripOnServiceDate().get(datedServiceJourneyId)) != null) {
            return tripOnServiceDate;
        }
        return this.transitModelIndex.getTripOnServiceDateById().get(datedServiceJourneyId);
    }

    @Override
    public Collection<TripOnServiceDate> getAllTripOnServiceDates() {
        return this.transitModelIndex.getTripOnServiceDateForTripAndDay().values();
    }

    @Override
    public TripOnServiceDate getTripOnServiceDateForTripAndDay(TripIdAndServiceDate tripIdAndServiceDate) {
        TripOnServiceDate tripOnServiceDate;
        TimetableSnapshot timetableSnapshot = this.lazyGetTimeTableSnapShot();
        if (timetableSnapshot != null && (tripOnServiceDate = timetableSnapshot.getRealtimeAddedTripOnServiceDateByTripIdAndServiceDate().get(tripIdAndServiceDate)) != null) {
            return tripOnServiceDate;
        }
        return this.transitModelIndex.getTripOnServiceDateForTripAndDay().get(tripIdAndServiceDate);
    }

    @Override
    public void addTransitMode(TransitMode mode) {
        this.transitModel.addTransitMode(mode);
    }

    @Override
    public Set<TransitMode> getTransitModes() {
        return this.transitModel.getTransitModes();
    }

    @Override
    public Collection<PathTransfer> getTransfersByStop(StopLocation stop) {
        return this.transitModel.getTransfersByStop(stop);
    }

    @Override
    public TransitLayer getTransitLayer() {
        return this.transitModel.getTransitLayer();
    }

    @Override
    public TransitLayer getRealtimeTransitLayer() {
        return this.transitModel.getRealtimeTransitLayer();
    }

    @Override
    public void setTransitLayer(TransitLayer transitLayer) {
        this.transitModel.setTransitLayer(transitLayer);
    }

    @Override
    public CalendarService getCalendarService() {
        return this.transitModel.getCalendarService();
    }

    @Override
    public ZoneId getTimeZone() {
        return this.transitModel.getTimeZone();
    }

    @Override
    public TransitAlertService getTransitAlertService() {
        return this.transitModel.getTransitAlertService();
    }

    @Override
    public FlexIndex getFlexIndex() {
        return this.transitModelIndex.getFlexIndex();
    }

    @Override
    public ZonedDateTime getTransitServiceEnds() {
        return this.transitModel.getTransitServiceEnds();
    }

    @Override
    public ZonedDateTime getTransitServiceStarts() {
        return this.transitModel.getTransitServiceStarts();
    }

    @Override
    public Collection<RegularStop> findRegularStop(Envelope envelope) {
        return this.transitModel.getStopModel().findRegularStops(envelope);
    }

    @Override
    public Collection<AreaStop> findAreaStops(Envelope envelope) {
        return this.transitModel.getStopModel().queryLocationIndex(envelope);
    }

    @Override
    public GraphUpdaterStatus getUpdaterStatus() {
        return this.transitModel.getUpdaterManager();
    }

    @Override
    public TransferService getTransferService() {
        return this.transitModel.getTransferService();
    }

    @Override
    public boolean transitFeedCovers(Instant dateTime) {
        return this.transitModel.transitFeedCovers(dateTime);
    }
}

