/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.transit.model.framework.AbstractEntityBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripAlteration;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;

public class TripOnServiceDateBuilder
extends AbstractEntityBuilder<TripOnServiceDate, TripOnServiceDateBuilder> {
    private Trip trip;
    private LocalDate serviceDate;
    private TripAlteration tripAlteration;
    private List<TripOnServiceDate> replacementFor = List.of();

    TripOnServiceDateBuilder(FeedScopedId id) {
        super(id);
    }

    TripOnServiceDateBuilder(TripOnServiceDate original) {
        super(original);
        this.trip = original.getTrip();
        this.serviceDate = original.getServiceDate();
        this.tripAlteration = original.getTripAlteration();
        this.replacementFor = new ArrayList<TripOnServiceDate>(original.getReplacementFor());
    }

    public TripOnServiceDateBuilder withTrip(Trip trip) {
        this.trip = trip;
        return this;
    }

    public TripOnServiceDateBuilder withServiceDate(LocalDate serviceDate) {
        this.serviceDate = serviceDate;
        return this;
    }

    public TripOnServiceDateBuilder withTripAlteration(TripAlteration tripAlteration) {
        this.tripAlteration = tripAlteration;
        return this;
    }

    public TripOnServiceDateBuilder withReplacementFor(List<TripOnServiceDate> replacementFor) {
        this.replacementFor = replacementFor;
        return this;
    }

    public Trip getTrip() {
        return this.trip;
    }

    public LocalDate getServiceDate() {
        return this.serviceDate;
    }

    public TripAlteration getTripAlteration() {
        return this.tripAlteration;
    }

    public List<TripOnServiceDate> getReplacementFor() {
        return this.replacementFor;
    }

    @Override
    protected TripOnServiceDate buildFromValues() {
        return new TripOnServiceDate(this);
    }
}

