/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.site;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.framework.AbstractEntityBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;

public class GroupStopBuilder
extends AbstractEntityBuilder<GroupStop, GroupStopBuilder> {
    private I18NString name;
    private Set<StopLocation> stopLocations = new HashSet<StopLocation>();
    private GeometryCollection geometry = new GeometryCollection(null, GeometryUtils.getGeometryFactory());
    private WgsCoordinate centroid;

    GroupStopBuilder(FeedScopedId id) {
        super(id);
    }

    GroupStopBuilder(@Nonnull GroupStop original) {
        super(original);
        this.name = original.getName();
        this.stopLocations = new HashSet<StopLocation>(original.getLocations());
        this.geometry = (GeometryCollection)original.getGeometry();
        this.centroid = original.getCoordinate();
    }

    @Override
    protected GroupStop buildFromValues() {
        return new GroupStop(this);
    }

    public GroupStopBuilder withName(I18NString name) {
        this.name = name;
        return this;
    }

    public I18NString name() {
        return this.name;
    }

    public GroupStopBuilder addLocation(StopLocation location) {
        this.stopLocations.add(location);
        int numGeometries = this.geometry.getNumGeometries();
        Geometry[] newGeometries = new Geometry[numGeometries + 1];
        for (int i = 0; i < numGeometries; ++i) {
            newGeometries[i] = this.geometry.getGeometryN(i);
        }
        if (location instanceof RegularStop) {
            WgsCoordinate coordinate = location.getCoordinate();
            Envelope envelope = new Envelope(coordinate.asJtsCoordinate());
            double xscale = Math.cos(coordinate.latitude() * Math.PI / 180.0);
            envelope.expandBy(100.0 / xscale, 100.0);
            newGeometries[numGeometries] = GeometryUtils.getGeometryFactory().toGeometry(envelope);
        } else if (location instanceof AreaStop) {
            newGeometries[numGeometries] = location.getGeometry();
        } else {
            throw new RuntimeException("Unknown location type");
        }
        this.geometry = new GeometryCollection(newGeometries, GeometryUtils.getGeometryFactory());
        this.centroid = new WgsCoordinate(this.geometry.getCentroid());
        return this;
    }

    public Set<StopLocation> stopLocations() {
        return Set.copyOf(this.stopLocations);
    }

    public GeometryCollection geometry() {
        return this.geometry;
    }

    public WgsCoordinate centroid() {
        return this.centroid;
    }
}

