/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.site;

import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.GroupStopBuilder;
import org.opentripplanner.transit.model.site.StopLocation;

public class GroupStop
extends AbstractTransitEntity<GroupStop, GroupStopBuilder>
implements StopLocation {
    private final int index = INDEX_COUNTER.getAndIncrement();
    private final Set<StopLocation> stopLocations;
    private final I18NString name;
    private final GeometryCollection geometry;
    private final WgsCoordinate centroid;

    GroupStop(GroupStopBuilder builder) {
        super(builder.getId());
        this.name = builder.name();
        this.geometry = builder.geometry();
        this.centroid = Objects.requireNonNull(builder.centroid());
        this.stopLocations = builder.stopLocations();
    }

    public static GroupStopBuilder of(FeedScopedId id) {
        return new GroupStopBuilder(id);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public I18NString getName() {
        return this.name;
    }

    @Override
    public I18NString getDescription() {
        return null;
    }

    @Override
    @Nullable
    public I18NString getUrl() {
        return null;
    }

    @Override
    public String getFirstZoneAsString() {
        return null;
    }

    @Override
    @Nonnull
    public WgsCoordinate getCoordinate() {
        return this.centroid;
    }

    @Override
    public Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    public boolean isPartOfStation() {
        return false;
    }

    @Override
    public boolean isPartOfSameStationAs(StopLocation alternativeStop) {
        return false;
    }

    public Set<StopLocation> getLocations() {
        return this.stopLocations;
    }

    @Override
    public boolean sameAs(@Nonnull GroupStop other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.name, other.getName()) && Objects.equals(this.stopLocations, other.getLocations());
    }

    @Nonnull
    public GroupStopBuilder copy() {
        return new GroupStopBuilder(this);
    }
}

