/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.site;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.AreaStopBuilder;
import org.opentripplanner.transit.model.site.StopLocation;

public class AreaStop
extends AbstractTransitEntity<AreaStop, AreaStopBuilder>
implements StopLocation {
    private final int index = INDEX_COUNTER.getAndIncrement();
    private final I18NString name;
    private final boolean hasFallbackName;
    private final I18NString description;
    private final Geometry geometry;
    private final String zoneId;
    private final I18NString url;
    private final WgsCoordinate centroid;

    AreaStop(AreaStopBuilder builder) {
        super(builder.getId());
        if (builder.name() == null) {
            this.name = new NonLocalizedString(builder.getId().toString());
            this.hasFallbackName = true;
        } else {
            this.name = builder.name();
            this.hasFallbackName = builder.hasFallbackName();
        }
        this.description = builder.description();
        this.url = builder.url();
        this.zoneId = builder.zoneId();
        this.geometry = builder.geometry();
        this.centroid = Objects.requireNonNull(builder.centroid());
    }

    public static AreaStopBuilder of(FeedScopedId id) {
        return new AreaStopBuilder(id);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    @Nonnull
    public I18NString getName() {
        return this.name;
    }

    @Override
    public I18NString getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public I18NString getUrl() {
        return this.url;
    }

    @Override
    public String getFirstZoneAsString() {
        return this.zoneId;
    }

    @Override
    @Nonnull
    public WgsCoordinate getCoordinate() {
        return this.centroid;
    }

    @Override
    public Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    public boolean isPartOfStation() {
        return false;
    }

    @Override
    public boolean isPartOfSameStationAs(StopLocation alternativeStop) {
        return false;
    }

    public boolean hasFallbackName() {
        return this.hasFallbackName;
    }

    @Override
    public boolean sameAs(@Nonnull AreaStop other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.name, other.getName()) && Objects.equals(this.description, other.getDescription()) && Objects.equals(this.geometry, other.getGeometry()) && Objects.equals(this.url, other.url) && Objects.equals(this.zoneId, other.zoneId);
    }

    @Nonnull
    public AreaStopBuilder copy() {
        return new AreaStopBuilder(this);
    }
}

