/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.organization;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.LogInfo;
import org.opentripplanner.transit.model.organization.BrandingBuilder;

public class Branding
extends AbstractTransitEntity<Branding, BrandingBuilder>
implements LogInfo {
    private final String name;
    private final String shortName;
    private final String url;
    private final String description;
    private final String image;

    Branding(BrandingBuilder builder) {
        super(builder.getId());
        this.name = builder.getName();
        this.shortName = builder.getShortName();
        this.url = builder.getUrl();
        this.description = builder.getDescription();
        this.image = builder.getImage();
    }

    public static BrandingBuilder of(@Nonnull FeedScopedId id) {
        return new BrandingBuilder(id);
    }

    @Nullable
    public String getName() {
        return this.logName();
    }

    @Override
    @Nullable
    public String logName() {
        return this.name;
    }

    @Nullable
    public String getShortName() {
        return this.shortName;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getImage() {
        return this.image;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public BrandingBuilder copy() {
        return new BrandingBuilder(this);
    }

    @Override
    public boolean sameAs(@Nonnull Branding other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.name, other.name) && Objects.equals(this.shortName, other.shortName) && Objects.equals(this.url, other.url) && Objects.equals(this.description, other.description) && Objects.equals(this.image, other.image);
    }
}

