/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.network;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;

public final class StopPattern
implements Serializable {
    public static final int NOT_FOUND = -1;
    private final StopLocation[] stops;
    private final PickDrop[] pickups;
    private final PickDrop[] dropoffs;

    private StopPattern(int size) {
        this.stops = new StopLocation[size];
        this.pickups = new PickDrop[size];
        this.dropoffs = new PickDrop[size];
    }

    private StopPattern(StopLocation[] stops, PickDrop[] pickups, PickDrop[] dropoffs) {
        this.stops = stops;
        this.pickups = pickups;
        this.dropoffs = dropoffs;
    }

    public StopPattern(Collection<StopTime> stopTimes) {
        this(stopTimes.size());
        int size = stopTimes.size();
        if (size == 0) {
            return;
        }
        Iterator<StopTime> stopTimeIterator = stopTimes.iterator();
        for (int i = 0; i < size; ++i) {
            StopTime stopTime = stopTimeIterator.next();
            this.stops[i] = stopTime.getStop();
            this.pickups[i] = StopPattern.computePickDrop(stopTime.getStop(), stopTime.getPickupType());
            this.dropoffs[i] = StopPattern.computePickDrop(stopTime.getStop(), stopTime.getDropOffType());
        }
    }

    public static StopPatternBuilder create(int length) {
        return new StopPatternBuilder(new StopPattern(length));
    }

    public StopPatternBuilder mutate() {
        return new StopPatternBuilder(this);
    }

    public int hashCode() {
        int hash = this.stops.length;
        hash += Arrays.hashCode(this.stops);
        hash *= 31;
        hash += Arrays.hashCode((Object[])this.pickups);
        hash *= 31;
        return hash += Arrays.hashCode((Object[])this.dropoffs);
    }

    public boolean equals(Object other) {
        if (other instanceof StopPattern) {
            StopPattern that = (StopPattern)other;
            return Arrays.equals(this.stops, that.stops) && Arrays.equals((Object[])this.pickups, (Object[])that.pickups) && Arrays.equals((Object[])this.dropoffs, (Object[])that.dropoffs);
        }
        return false;
    }

    public boolean stopsEqual(Object other) {
        if (other instanceof StopPattern) {
            StopPattern that = (StopPattern)other;
            return Arrays.equals(this.stops, that.stops);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StopPattern: ");
        int j = this.stops.length;
        for (int i = 0; i < j; ++i) {
            sb.append(String.format("%s_%s%s ", new Object[]{this.stops[i].getCode(), this.pickups[i], this.dropoffs[i]}));
        }
        return sb.toString();
    }

    public int getSize() {
        return this.stops.length;
    }

    public boolean isAllStopsNonRoutable() {
        return Arrays.stream(this.pickups).allMatch(PickDrop::isNotRoutable) && Arrays.stream(this.dropoffs).allMatch(PickDrop::isNotRoutable);
    }

    int findStopPosition(StopLocation stop) {
        for (int i = 0; i < this.stops.length; ++i) {
            if (this.stops[i] != stop) continue;
            return i;
        }
        return -1;
    }

    int findBoardingPosition(StopLocation stop) {
        return this.findStopPosition(0, this.stops.length - 1, s -> s == stop);
    }

    int findAlightPosition(StopLocation stop) {
        return this.findStopPosition(1, this.stops.length, s -> s == stop);
    }

    int findBoardingPosition(Station station) {
        return this.findStopPosition(0, this.stops.length - 1, station::includes);
    }

    int findAlightPosition(Station station) {
        return this.findStopPosition(1, this.stops.length, station::includes);
    }

    List<StopLocation> getStops() {
        return List.of(this.stops);
    }

    public StopLocation getStop(int stopPosInPattern) {
        return this.stops[stopPosInPattern];
    }

    PickDrop getPickup(int stopPosInPattern) {
        return this.pickups[stopPosInPattern];
    }

    PickDrop getDropoff(int stopPosInPattern) {
        return this.dropoffs[stopPosInPattern];
    }

    boolean canAlight(int stopPosInPattern) {
        return this.dropoffs[stopPosInPattern].isRoutable();
    }

    boolean canAlight(StopLocation stop) {
        for (int i = 0; i < this.stops.length - 1; ++i) {
            if (stop != this.stops[i] || !this.canAlight(i)) continue;
            return true;
        }
        return false;
    }

    boolean canBoard(int stopPosInPattern) {
        return this.pickups[stopPosInPattern].isRoutable();
    }

    boolean canBoard(StopLocation stop) {
        for (int i = 0; i < this.stops.length - 1; ++i) {
            if (stop != this.stops[i] || !this.canBoard(i)) continue;
            return true;
        }
        return false;
    }

    private static PickDrop computePickDrop(StopLocation stop, PickDrop pickDrop) {
        if (stop instanceof RegularStop) {
            return pickDrop;
        }
        return PickDrop.NONE;
    }

    private int findStopPosition(int start, int end, Predicate<StopLocation> match) {
        for (int i = start; i < end; ++i) {
            if (!match.test(this.stops[i])) continue;
            return i;
        }
        return -1;
    }

    boolean sameStops(@Nonnull StopPattern other, int index) {
        StopLocation otherOrigin = other.getStop(index);
        StopLocation otherDestination = other.getStop(index + 1);
        StopLocation origin = this.getStop(index);
        StopLocation destination = this.getStop(index + 1);
        return origin.equals(otherOrigin) && destination.equals(otherDestination);
    }

    boolean sameStations(@Nonnull StopPattern other, int index) {
        Station otherOrigin = other.getStop(index).getParentStation();
        Station otherDestination = other.getStop(index + 1).getParentStation();
        Station origin = this.getStop(index).getParentStation();
        Station destionation = this.getStop(index + 1).getParentStation();
        Boolean sameOrigin = Optional.ofNullable(origin).map(o -> o.equals(otherOrigin)).orElse(this.getStop(index).equals(other.getStop(index)));
        Boolean sameDestination = Optional.ofNullable(destionation).map(o -> o.equals(otherDestination)).orElse(this.getStop(index + 1).equals(other.getStop(index + 1)));
        return sameOrigin != false && sameDestination != false;
    }

    public static class StopPatternBuilder {
        public final StopLocation[] stops;
        public final PickDrop[] pickups;
        public final PickDrop[] dropoffs;
        private final StopPattern original;

        public StopPatternBuilder(StopPattern original) {
            this.stops = Arrays.copyOf(original.stops, original.stops.length);
            this.pickups = Arrays.copyOf(original.pickups, original.pickups.length);
            this.dropoffs = Arrays.copyOf(original.dropoffs, original.dropoffs.length);
            this.original = original;
        }

        public StopPatternBuilder cancelStops(List<Integer> cancelledStopIndices) {
            cancelledStopIndices.forEach(index -> {
                this.pickups[index.intValue()] = PickDrop.CANCELLED;
                this.dropoffs[index.intValue()] = PickDrop.CANCELLED;
            });
            return this;
        }

        public StopPattern build() {
            boolean sameStops = Arrays.equals(this.stops, this.original.stops);
            boolean sameDropoffs = Arrays.equals((Object[])this.dropoffs, (Object[])this.original.dropoffs);
            boolean samePickups = Arrays.equals((Object[])this.pickups, (Object[])this.original.pickups);
            if (sameStops && samePickups && sameDropoffs) {
                return this.original;
            }
            StopLocation[] newStops = sameStops ? this.original.stops : this.stops;
            PickDrop[] newPickups = samePickups ? this.original.pickups : this.pickups;
            PickDrop[] newDropoffs = sameDropoffs ? this.original.dropoffs : this.dropoffs;
            return new StopPattern(newStops, newPickups, newDropoffs);
        }
    }
}

