/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.framework;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Result<T, E> {
    private Result() {
    }

    public static <T, E> Result<T, E> failure(@Nonnull E failure) {
        return new Failure(failure);
    }

    public static <T, E> Result<T, E> success(@Nonnull T success) {
        return new Success(success);
    }

    public static <E> Result<Void, E> success() {
        return new Success(null);
    }

    public <N> Result<N, E> mapSuccess(Function<T, N> mapper) {
        if (this.isSuccess()) {
            return Result.success(mapper.apply(this.successValue()));
        }
        return Result.failure(this.failureValue());
    }

    public <N> Result<N, E> toFailureResult() {
        return Result.failure(this.failureValue());
    }

    protected abstract Object value();

    public E failureValue() {
        if (this.isFailure()) {
            return (E)this.value();
        }
        throw new RuntimeException("Value %s is not a failure. Check isFailure() before calling failureValue().".formatted(this.value()));
    }

    public abstract boolean isSuccess();

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public abstract void ifSuccess(Consumer<T> var1);

    public abstract void ifFailure(Consumer<E> var1);

    public T successValue() {
        if (this.isSuccess()) {
            return (T)this.value();
        }
        throw new RuntimeException("Value %s is not a success. Check isSuccess() before calling successValue().".formatted(this.value()));
    }

    private static final class Failure<T, E>
    extends Result<T, E> {
        private final E failure;

        private Failure(E failure) {
            Objects.requireNonNull(failure, "failure must not be null");
            this.failure = failure;
        }

        @Override
        protected E value() {
            return this.failure;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public void ifSuccess(Consumer<T> func) {
        }

        @Override
        public void ifFailure(Consumer<E> func) {
            func.accept(this.failure);
        }
    }

    private static final class Success<T, E>
    extends Result<T, E> {
        private final T success;

        private Success(T success) {
            this.success = success;
        }

        @Override
        protected T value() {
            return this.success;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public void ifSuccess(Consumer<T> func) {
            func.accept(this.success);
        }

        @Override
        public void ifFailure(Consumer<E> func) {
        }
    }
}

