/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.framework;

import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.opentripplanner.framework.tostring.ToStringBuilder;

public class Deduplicator
implements Serializable {
    private static final String ZERO_COUNT = Deduplicator.sizeAndCount(0, 0);
    private final Map<BitSet, BitSet> canonicalBitSets = new HashMap<BitSet, BitSet>();
    private final Map<IntArray, IntArray> canonicalIntArrays = new HashMap<IntArray, IntArray>();
    private final Map<String, String> canonicalStrings = new HashMap<String, String>();
    private final Map<StringArray, StringArray> canonicalStringArrays = new HashMap<StringArray, StringArray>();
    private final Map<String2DArray, String2DArray> canonicalString2DArrays = new HashMap<String2DArray, String2DArray>();
    private final Map<Class<?>, Map<?, ?>> canonicalObjects = new HashMap();
    private final Map<Class<?>, Map<?, ?>> canonicalObjArrays = new HashMap();
    private final Map<Class<?>, Map<List<?>, List<?>>> canonicalLists = new HashMap();
    private final Map<String, Integer> effectCounter = new HashMap<String, Integer>();

    @Inject
    public Deduplicator() {
    }

    public void reset() {
        this.canonicalBitSets.clear();
        this.canonicalIntArrays.clear();
        this.canonicalStrings.clear();
        this.canonicalStringArrays.clear();
        this.canonicalString2DArrays.clear();
        this.canonicalObjects.clear();
        this.canonicalObjArrays.clear();
        this.canonicalLists.clear();
    }

    @Nullable
    public BitSet deduplicateBitSet(BitSet original) {
        if (original == null) {
            return null;
        }
        BitSet canonical = this.canonicalBitSets.get(original);
        if (canonical == null) {
            canonical = original;
            this.canonicalBitSets.put(canonical, canonical);
        }
        this.incrementEffectCounter(BitSet.class);
        return canonical;
    }

    @Nullable
    public int[] deduplicateIntArray(int[] original) {
        if (original == null) {
            return null;
        }
        IntArray intArray = new IntArray(original);
        IntArray canonical = this.canonicalIntArrays.get(intArray);
        if (canonical == null) {
            canonical = intArray;
            this.canonicalIntArrays.put(canonical, canonical);
        }
        this.incrementEffectCounter(IntArray.class);
        return canonical.array;
    }

    @Nullable
    public String deduplicateString(String original) {
        if (original == null) {
            return null;
        }
        String canonical = this.canonicalStrings.putIfAbsent(original, original);
        this.incrementEffectCounter(String.class);
        return canonical == null ? original : canonical;
    }

    @Nullable
    public String[] deduplicateStringArray(String[] original) {
        if (original == null) {
            return null;
        }
        StringArray canonical = this.canonicalStringArrays.get(new StringArray(original));
        if (canonical == null) {
            canonical = StringArray.deepDeduplicateOf(original, this);
            this.canonicalStringArrays.put(canonical, canonical);
        }
        this.incrementEffectCounter(StringArray.class);
        return canonical.array;
    }

    @Nullable
    public String[][] deduplicateString2DArray(String[][] original) {
        if (original == null) {
            return null;
        }
        String2DArray canonical = this.canonicalString2DArrays.get(new String2DArray(original));
        if (canonical == null) {
            canonical = String2DArray.deepDeduplicateOf(original, this);
            this.canonicalString2DArrays.put(canonical, canonical);
        }
        this.incrementEffectCounter(String2DArray.class);
        return canonical.array;
    }

    @Nullable
    public <T> T deduplicateObject(Class<T> cl, T original) {
        if (String.class == cl) {
            throw new IllegalArgumentException("Use #deduplicateString() instead.");
        }
        if (original == null) {
            return null;
        }
        Map objects = this.canonicalObjects.computeIfAbsent(cl, c -> new HashMap());
        T canonical = objects.putIfAbsent(original, original);
        this.incrementEffectCounter(Deduplicator.objCounterName(cl));
        return canonical == null ? original : canonical;
    }

    @Nullable
    public <T> T[] deduplicateObjectArray(Class<T> type, T[] original) {
        Map<Object, Object> map;
        if (original == null) {
            return null;
        }
        if (this.canonicalObjArrays.containsKey(type)) {
            map = this.canonicalObjArrays.get(type);
        } else {
            map = new HashMap();
            this.canonicalObjArrays.put(type, map);
        }
        ObjArray<T> canonical = (ObjArray<T>)map.get(new ObjArray<T>(original));
        if (canonical == null) {
            canonical = ObjArray.deepDeduplicateOf(type, original, this);
            map.put(canonical, canonical);
        }
        this.incrementEffectCounter(Deduplicator.arrayCounterName(type));
        return canonical.array();
    }

    @Nullable
    public <T> List<T> deduplicateImmutableList(Class<T> clazz, List<T> original) {
        if (original == null) {
            return null;
        }
        Map canonicalLists = this.canonicalLists.computeIfAbsent(clazz, key -> new HashMap());
        List canonical = (List)canonicalLists.get(original);
        if (canonical == null) {
            boolean containsNull = original.stream().anyMatch(Objects::isNull);
            Stream<Object> stream = original.stream().map(it -> this.deduplicateObject(clazz, it));
            canonical = containsNull ? Collections.unmodifiableList(stream.collect(Collectors.toList())) : stream.collect(Collectors.toUnmodifiableList());
            canonicalLists.put(canonical, canonical);
        }
        this.incrementEffectCounter(Deduplicator.listCounterName(clazz));
        return canonical;
    }

    public String toString() {
        ToStringBuilder builder = ToStringBuilder.of(Deduplicator.class).addObj("BitSet", this.sizeAndCount(this.canonicalBitSets.size(), BitSet.class), ZERO_COUNT).addObj("int[]", this.sizeAndCount(this.canonicalIntArrays.size(), IntArray.class), ZERO_COUNT).addObj("String", this.sizeAndCount(this.canonicalStrings.size(), String.class), ZERO_COUNT).addObj("String[]", this.sizeAndCount(this.canonicalStringArrays.size(), StringArray.class), ZERO_COUNT).addObj("String[][]", this.sizeAndCount(this.canonicalString2DArrays.size(), String2DArray.class), ZERO_COUNT);
        this.addToBuilder(builder, this.canonicalObjects, Deduplicator::objCounterName);
        this.addToBuilder(builder, this.canonicalObjArrays, Deduplicator::arrayCounterName);
        this.addToBuilder(builder, this.canonicalLists, Deduplicator::listCounterName);
        return builder.toString();
    }

    private static <T> String objCounterName(Class<T> type) {
        return type.getSimpleName();
    }

    private static <T> String listCounterName(Class<T> type) {
        return "List<" + type.getSimpleName() + ">";
    }

    private static <T> String arrayCounterName(Class<T> type) {
        return type.getSimpleName() + "[]";
    }

    private <K, V extends Map<?, ?>> void addToBuilder(ToStringBuilder builder, Map<K, V> map, Function<K, String> toName) {
        map.entrySet().stream().map(e -> new NameSize((String)toName.apply(e.getKey()), ((Map)e.getValue()).size())).sorted(Comparator.comparing(NameSize::name)).forEach(it -> builder.addObj(it.name(), this.sizeAndCount(it.size(), it.name()), ZERO_COUNT));
    }

    private void incrementEffectCounter(Class<?> clazz) {
        this.incrementEffectCounter(clazz.getName());
    }

    private void incrementEffectCounter(String key) {
        this.effectCounter.compute(key, (k, v) -> {
            int n;
            if (v == null) {
                n = 1;
            } else {
                v = v + 1;
                n = v;
            }
            return n;
        });
    }

    private String sizeAndCount(int size, Class<?> clazz) {
        return this.sizeAndCount(size, clazz.getName());
    }

    private String sizeAndCount(int size, String key) {
        int count = this.effectCounter.getOrDefault(key, 0);
        return Deduplicator.sizeAndCount(size, count);
    }

    private static String sizeAndCount(int size, int count) {
        return size + "(" + count + ")";
    }

    private record IntArray(int[] array) implements Serializable
    {
        @Override
        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof IntArray) {
                IntArray that = (IntArray)other;
                return Arrays.equals(this.array, that.array);
            }
            return false;
        }
    }

    private record StringArray(String[] array) implements Serializable
    {
        private static StringArray deepDeduplicateOf(String[] array, Deduplicator deduplicator) {
            String[] copy = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                copy[i] = deduplicator.deduplicateString(array[i]);
            }
            return new StringArray(copy);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof StringArray) {
                StringArray that = (StringArray)other;
                return Arrays.equals(this.array, that.array);
            }
            return false;
        }
    }

    private record String2DArray(String[][] array) implements Serializable
    {
        private static String2DArray deepDeduplicateOf(String[][] array, Deduplicator deduplicator) {
            String[][] copy = new String[array.length][];
            for (int i = 0; i < array.length; ++i) {
                copy[i] = deduplicator.deduplicateStringArray(array[i]);
            }
            return new String2DArray(copy);
        }

        @Override
        public int hashCode() {
            return Arrays.deepHashCode((Object[])this.array);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof String2DArray) {
                String2DArray that = (String2DArray)other;
                return Arrays.deepEquals((Object[])this.array, (Object[])that.array);
            }
            return false;
        }
    }

    private record ObjArray<T>(T[] array) implements Serializable
    {
        private static <E> ObjArray<E> deepDeduplicateOf(Class<E> type, E[] array, Deduplicator deduplicator) {
            E[] copy = Arrays.copyOf(array, array.length);
            for (int i = 0; i < array.length; ++i) {
                copy[i] = deduplicator.deduplicateObject(type, array[i]);
            }
            return new ObjArray<E>(copy);
        }

        @Override
        public int hashCode() {
            return Arrays.deepHashCode(this.array);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof ObjArray) {
                ObjArray that = (ObjArray)other;
                return Arrays.deepEquals(this.array, that.array);
            }
            return false;
        }
    }

    private record NameSize(String name, int size) {
    }
}

