/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.framework;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opentripplanner.transit.model.framework.AbstractEntityBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.LogInfo;
import org.opentripplanner.transit.model.framework.TransitEntity;
import org.opentripplanner.transit.model.framework.TransitObject;

public abstract class AbstractTransitEntity<E extends AbstractTransitEntity<E, B>, B extends AbstractEntityBuilder<E, B>>
implements TransitEntity,
TransitObject<E, B>,
Serializable {
    private final FeedScopedId id;

    public AbstractTransitEntity(@Nonnull FeedScopedId id) {
        this.id = Objects.requireNonNull(id);
    }

    @Override
    public final FeedScopedId getId() {
        return this.id;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTransitEntity other = (AbstractTransitEntity)obj;
        return this.getId().equals(other.getId());
    }

    public final String toString() {
        LogInfo n;
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName());
        buf.append('{').append(this.getId());
        AbstractTransitEntity abstractTransitEntity = this;
        if (abstractTransitEntity instanceof LogInfo && (n = (LogInfo)((Object)abstractTransitEntity)).logName() != null) {
            buf.append(' ').append(n.logName());
        }
        buf.append('}');
        return buf.toString();
    }

    protected static <T> List<T> listOfNullSafe(List<T> list) {
        if (list == null || list.isEmpty()) {
            return List.of();
        }
        return List.copyOf(list);
    }

    protected static <T> Set<T> setOfNullSafe(Collection<T> input) {
        if (input == null || input.isEmpty()) {
            return Set.of();
        }
        return Set.copyOf(input);
    }
}

