/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.search.state;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.request.StreetSearchRequest;
import org.opentripplanner.street.search.state.CarPickupState;
import org.opentripplanner.street.search.state.VehicleRentalState;

public class StateData
implements Cloneable {
    protected boolean vehicleParked;
    protected VehicleRentalState vehicleRentalState;
    protected boolean mayKeepRentedVehicleAtDestination;
    protected CarPickupState carPickupState;
    protected TraverseMode currentMode;
    protected TraverseMode backMode;
    protected boolean backWalkingBike;
    public String vehicleRentalNetwork;
    public RentalFormFactor rentalVehicleFormFactor;
    protected boolean enteredNoThroughTrafficArea;
    protected boolean insideNoRentalDropOffArea = false;
    public Set<String> noRentalDropOffZonesAtStartOfReverseSearch = Set.of();

    protected StateData(StreetMode requestMode) {
        this.currentMode = switch (requestMode) {
            default -> throw new IncompatibleClassChangeError();
            case StreetMode.NOT_SET, StreetMode.WALK, StreetMode.BIKE_RENTAL, StreetMode.SCOOTER_RENTAL, StreetMode.CAR_RENTAL, StreetMode.FLEXIBLE -> TraverseMode.WALK;
            case StreetMode.BIKE, StreetMode.BIKE_TO_PARK -> TraverseMode.BICYCLE;
            case StreetMode.CAR, StreetMode.CAR_TO_PARK, StreetMode.CAR_PICKUP, StreetMode.CAR_HAILING -> TraverseMode.CAR;
        };
    }

    public static List<StateData> getInitialStateDatas(StreetSearchRequest request) {
        return StateData.getInitialStateDatas(request, StateData::new);
    }

    public static List<StateData> getInitialStateDatas(StreetSearchRequest request, Function<StreetMode, StateData> stateDataConstructor) {
        return StateData.getInitialStateDatas(request.mode(), request.arriveBy(), request.rental().allowArrivingInRentedVehicleAtDestination(), false, stateDataConstructor);
    }

    public static StateData getInitialStateData(StreetSearchRequest request) {
        List<StateData> stateDatas = StateData.getInitialStateDatas(request.mode(), request.arriveBy(), request.rental().allowArrivingInRentedVehicleAtDestination(), true, StateData::new);
        if (stateDatas.size() != 1) {
            throw new IllegalStateException("Unable to create only a single state");
        }
        return stateDatas.get(0);
    }

    private static List<StateData> getInitialStateDatas(StreetMode requestMode, boolean arriveBy, boolean allowArrivingInRentedVehicleAtDestination, boolean forceSingleState, Function<StreetMode, StateData> stateDataConstructor) {
        ArrayList<StateData> res = new ArrayList<StateData>();
        StateData proto = stateDataConstructor.apply(requestMode);
        if (requestMode.includesPickup()) {
            if (!forceSingleState) {
                StateData inCarPickupStateData = proto.clone();
                inCarPickupStateData.carPickupState = CarPickupState.IN_CAR;
                inCarPickupStateData.currentMode = TraverseMode.CAR;
                res.add(inCarPickupStateData);
            }
            StateData walkingPickupStateData = proto.clone();
            walkingPickupStateData.carPickupState = arriveBy ? CarPickupState.WALK_FROM_DROP_OFF : CarPickupState.WALK_TO_PICKUP;
            walkingPickupStateData.currentMode = TraverseMode.WALK;
            res.add(walkingPickupStateData);
        } else if (requestMode.includesRenting()) {
            if (arriveBy) {
                if (!forceSingleState) {
                    if (allowArrivingInRentedVehicleAtDestination) {
                        StateData keptVehicleStateData = proto.clone();
                        keptVehicleStateData.vehicleRentalState = VehicleRentalState.RENTING_FROM_STATION;
                        keptVehicleStateData.currentMode = TraverseMode.BICYCLE;
                        keptVehicleStateData.mayKeepRentedVehicleAtDestination = true;
                        res.add(keptVehicleStateData);
                    }
                    StateData floatingRentalStateData = proto.clone();
                    floatingRentalStateData.vehicleRentalState = VehicleRentalState.RENTING_FLOATING;
                    floatingRentalStateData.rentalVehicleFormFactor = StateData.toFormFactor(requestMode);
                    floatingRentalStateData.currentMode = TraverseMode.BICYCLE;
                    res.add(floatingRentalStateData);
                }
                StateData stationReturnedStateData = proto.clone();
                stationReturnedStateData.vehicleRentalState = VehicleRentalState.HAVE_RENTED;
                stationReturnedStateData.currentMode = TraverseMode.WALK;
                res.add(stationReturnedStateData);
            } else {
                StateData beforeRentalStateData = proto.clone();
                beforeRentalStateData.vehicleRentalState = VehicleRentalState.BEFORE_RENTING;
                res.add(beforeRentalStateData);
            }
        } else if (requestMode.includesParking()) {
            StateData parkAndRideStateData = proto.clone();
            parkAndRideStateData.vehicleParked = arriveBy;
            parkAndRideStateData.currentMode = parkAndRideStateData.vehicleParked ? TraverseMode.WALK : (requestMode.includesBiking() ? TraverseMode.BICYCLE : TraverseMode.CAR);
            res.add(parkAndRideStateData);
        } else {
            res.add(proto.clone());
        }
        return res;
    }

    private static RentalFormFactor toFormFactor(StreetMode streetMode) {
        return switch (streetMode) {
            default -> throw new IncompatibleClassChangeError();
            case StreetMode.BIKE_RENTAL -> RentalFormFactor.BICYCLE;
            case StreetMode.SCOOTER_RENTAL -> RentalFormFactor.SCOOTER;
            case StreetMode.CAR_RENTAL -> RentalFormFactor.CAR;
            case StreetMode.NOT_SET, StreetMode.WALK, StreetMode.FLEXIBLE, StreetMode.BIKE, StreetMode.BIKE_TO_PARK, StreetMode.CAR, StreetMode.CAR_TO_PARK, StreetMode.CAR_PICKUP, StreetMode.CAR_HAILING -> throw new IllegalStateException("Cannot convert street mode %s to a form factor".formatted(new Object[]{streetMode}));
        };
    }

    public StateData clone() {
        try {
            return (StateData)super.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new IllegalStateException("This is not happening");
        }
    }
}

